; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - SPRITES.prg
; -------------------------------------------------------------------------------------------------------------- ;
                        * equ $3fe9                 ; TabSpriteData - CopySpriteDataToStore
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteDataOrig       = TabSpriteData             ; 
TabSpriteDataStore      = $e000                     ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CopySpriteDataToStore Does    : Copies sprite data from load point to game sprite store
;                       Expects : 
;                       Returns : 
;                       Misc    : Called from BASIC
; -------------------------------------------------------------------------------------------------------------- ;
CopySpriteDataToStore   subroutine                  ; 
                        ldy #$1e                    ; pages
                        ldx #$00                    ; bytes/page
__SpriteDataCopyFrom    equ * + $02                 ; 
.GetSpriteDataCopy      lda TabSpriteDataOrig,x     ; 
__SpriteDataCopyTo      equ * + $02                 ; 
.SetSpriteDataCopy      sta TabSpriteDataStore,x    ; 
                        inx                         ; 
                        bne .GetSpriteDataCopy      ; 
                        
                        inc __SpriteDataCopyFrom    ; next page
                        inc __SpriteDataCopyTo      ; 
                        
                        dey                         ; count
                        bne .GetSpriteDataCopy      ; 
                        
CopySpriteDataToStoreX  rts                         ; back to BASIC
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteData           equ  *                      ; data from here on copied over to SpriteStore at $e000
                        rorg TabSpriteDataStore
; -------------------------------------------------------------------------------------------------------------- ;
SP_SpriteDatPtrLo_Map   dc.b <SP_Dat_Map_00 ; fleet 1 ship
                        dc.b <SP_Dat_Map_01 ; fleet 2 ships
                        dc.b <SP_Dat_Map_02 ; fleet 3 ships
                        dc.b <SP_Dat_Map_03 ; fleet 4 ships
                        dc.b <SP_Dat_Map_04 ; fleet 4 ships 1 n
                        dc.b <SP_Dat_Map_05 ; fleet 4 ships 1 ne
                        dc.b <SP_Dat_Map_06 ; fleet 4 ships 1 e
                        dc.b <SP_Dat_Map_07 ; fleet 4 ships 1 se
                        dc.b <SP_Dat_Map_08 ; fleet 5 ships
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
SP_SpriteDatPtrHi_Map   dc.b >SP_Dat_Map_00 ; fleet 1 ship
                        dc.b >SP_Dat_Map_01 ; fleet 2 ships
                        dc.b >SP_Dat_Map_02 ; fleet 3 ships
                        dc.b >SP_Dat_Map_03 ; fleet 4 ships
                        dc.b >SP_Dat_Map_04 ; fleet 4 ships 1 n
                        dc.b >SP_Dat_Map_05 ; fleet 4 ships 1 ne
                        dc.b >SP_Dat_Map_06 ; fleet 4 ships 1 e
                        dc.b >SP_Dat_Map_07 ; fleet 4 ships 1 se
                        dc.b >SP_Dat_Map_08 ; fleet 5 ships
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
SP_SpriteDatPtrLo_Cave  dc.b <SP_Dat_Cave_00 ; torpedo n
                        dc.b <SP_Dat_Cave_01 ; torpedo nne
                        dc.b <SP_Dat_Cave_02 ; torpedo ne
                        dc.b <SP_Dat_Cave_03 ; torpedo nee
                        dc.b <SP_Dat_Cave_04 ; torpedo e
                        dc.b <SP_Dat_Cave_05 ; torpedo see
                        dc.b <SP_Dat_Cave_06 ; torpedo se
                        dc.b <SP_Dat_Cave_07 ; torpedo sse
                        dc.b <SP_Dat_Cave_08 ; ship w
                        dc.b <SP_Dat_Cave_09 ; ship nww
                        dc.b <SP_Dat_Cave_0a ; ship nw
                        dc.b <SP_Dat_Cave_0b ; ship nnw
                        dc.b <SP_Dat_Cave_0c ; ship n
                        dc.b <SP_Dat_Cave_0d ; explosion phase 1
                        dc.b <SP_Dat_Cave_0e ; explosion phase 2
                        dc.b <SP_Dat_Cave_0f ; explosion phase 3
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
SP_SpriteDatPtrHi_Cave  dc.b >SP_Dat_Cave_00 ; torpedo n
                        dc.b >SP_Dat_Cave_01 ; torpedo nne
                        dc.b >SP_Dat_Cave_02 ; torpedo ne
                        dc.b >SP_Dat_Cave_03 ; torpedo nee
                        dc.b >SP_Dat_Cave_04 ; torpedo e
                        dc.b >SP_Dat_Cave_05 ; torpedo see
                        dc.b >SP_Dat_Cave_06 ; torpedo se
                        dc.b >SP_Dat_Cave_07 ; torpedo sse
                        dc.b >SP_Dat_Cave_08 ; ship w
                        dc.b >SP_Dat_Cave_09 ; ship nww
                        dc.b >SP_Dat_Cave_0a ; ship nw
                        dc.b >SP_Dat_Cave_0b ; ship nnw
                        dc.b >SP_Dat_Cave_0c ; ship n
                        dc.b >SP_Dat_Cave_0d ; explosion phase 1
                        dc.b >SP_Dat_Cave_0e ; explosion phase 2
                        dc.b >SP_Dat_Cave_0f ; explosion phase 3
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
SP_SpriteDatPtrLo_Plane dc.b <SP_Dat_Plane_00 ; plane single sprite phase 1
                        dc.b <SP_Dat_Plane_01 ; plane single sprite phase 2
                        dc.b <SP_Dat_Plane_02 ; plane single sprite phase 3
                        dc.b <SP_Dat_Plane_03 ; plane single sprite phase 4
                        dc.b <SP_Dat_Plane_04 ; plane single sprite phase 5
                        dc.b <SP_Dat_Plane_05 ; plane single sprite phase 6
                        dc.b <SP_Dat_Plane_06 ; plane single sprite phase 7
                        dc.b <SP_Dat_Plane_07 ; plane double sprite phase 1 left
                        dc.b <SP_Dat_Plane_08 ; plane double sprite phase 1 right
                        dc.b <SP_Dat_Plane_09 ; plane double sprite phase 2 left
                        dc.b <SP_Dat_Plane_0a ; plane double sprite phase 2 right
                        dc.b <SP_Dat_Plane_0b ; plane double sprite phase 3 left
                        dc.b <SP_Dat_Plane_0c ; plane double sprite phase 3 right
                        dc.b <SP_Dat_Plane_0d ; plane double sprite phase 4 left
                        dc.b <SP_Dat_Plane_0e ; plane double sprite phase 4 right
                        dc.b <SP_Dat_Plane_0f ; plane double sprite phase 5 left
                        dc.b <SP_Dat_Plane_10 ; plane double sprite phase 5 right
                        dc.b <SP_Dat_Plane_11 ; plane turn away mid phase 1 left
                        dc.b <SP_Dat_Plane_12 ; plane turn away mid phase 1 right
                        dc.b <SP_Dat_Plane_13 ; plane turn away mid phase 2 left
                        dc.b <SP_Dat_Plane_14 ; plane turn away mid phase 3 right
                        dc.b <SP_Dat_Plane_15 ; plane turn away mid phase 3 left
                        dc.b <SP_Dat_Plane_16 ; plane turn away mid phase 3 right
                        dc.b <SP_Dat_Plane_17 ; plane turn away left phase 1 left
                        dc.b <SP_Dat_Plane_18 ; plane turn away left phase 1 right
                        dc.b <SP_Dat_Plane_19 ; plane turn away left phase 2 left
                        dc.b <SP_Dat_Plane_1a ; plane turn away left phase 2 right
                        dc.b <SP_Dat_Plane_1b ; plane turn away left phase 3 left
                        dc.b <SP_Dat_Plane_1c ; plane turn away left phase 3 right
                        dc.b <SP_Dat_Plane_1d ; plane turn away right phase 1 left
                        dc.b <SP_Dat_Plane_1e ; plane turn away right phase 1 right
                        dc.b <SP_Dat_Plane_1f ; plane turn away right phase 2 left
                        dc.b <SP_Dat_Plane_20 ; plane turn away right phase 2 right
                        dc.b <SP_Dat_Plane_21 ; plane turn away right phase 3 left
                        dc.b <SP_Dat_Plane_22 ; plane turn away right phase 3 right
                        dc.b <SP_Dat_Plane_23 ; target cross
                        dc.b <SP_Dat_Plane_24 ; bullet phase  1 - max
                        dc.b <SP_Dat_Plane_25 ; bullet phase  2
                        dc.b <SP_Dat_Plane_26 ; bullet phase  3
                        dc.b <SP_Dat_Plane_27 ; bullet phase  4
                        dc.b <SP_Dat_Plane_28 ; bullet phase  5
                        dc.b <SP_Dat_Plane_29 ; bullet phase  6
                        dc.b <SP_Dat_Plane_2a ; bullet phase  7
                        dc.b <SP_Dat_Plane_2b ; bullet phase  8
                        dc.b <SP_Dat_Plane_2c ; bullet phase  9
                        dc.b <SP_Dat_Plane_2d ; bullet phase 10
                        dc.b <SP_Dat_Plane_2e ; bullet phase 11
                        dc.b <SP_Dat_Plane_2f ; bullet phase 12 - min
                        dc.b <SP_Dat_Plane_30 ; cannon move up max
                        dc.b <SP_Dat_Plane_31 ; cannon move down phase  1
                        dc.b <SP_Dat_Plane_32 ; cannon move down phase  2
                        dc.b <SP_Dat_Plane_33 ; cannon move down phase  3
                        dc.b <SP_Dat_Plane_34 ; cannon move down phase  4
                        dc.b <SP_Dat_Plane_35 ; cannon move down phase  5
                        dc.b <SP_Dat_Plane_36 ; cannon move down phase  6
                        dc.b <SP_Dat_Plane_37 ; cannon move down phase  7
                        dc.b <SP_Dat_Plane_38 ; cannon move down phase  8
                        dc.b <SP_Dat_Plane_39 ; cannon move down phase  9
                        dc.b <SP_Dat_Plane_3a ; cannon move down phase 10
                        dc.b <SP_Dat_Plane_3b ; cannon move down phase 11
                        dc.b <SP_Dat_Plane_3c ; cannon move down phase 12
                        dc.b <SP_Dat_Plane_3d ; cannon move down phase 13
                        dc.b <SP_Dat_Plane_3e ; cannon move down phase 14
                        dc.b <SP_Dat_Plane_3f ; cannon move down phase 15
                        dc.b <SP_Dat_Plane_40 ; cannon move down max
                        dc.b <SP_Dat_Plane_41 ; enemy shot min
                        dc.b <SP_Dat_Plane_42 ; enemy shot phase 1
                        dc.b <SP_Dat_Plane_43 ; enemy shot phase 2
                        dc.b <SP_Dat_Plane_44 ; enemy shot phase 3
                        dc.b <SP_Dat_Plane_45 ; enemy shot phase 4
                        dc.b <SP_Dat_Plane_46 ; enemy shot phase 5
                        dc.b <SP_Dat_Plane_47 ; enemy shot max
                        dc.b <SP_Dat_Plane_48 ; explode transporter
                        dc.b <SP_Dat_Plane_49 ; explode plane left
                        dc.b <SP_Dat_Plane_4a ; explode plane right
                        dc.b <SP_Dat_Plane_4b ; transporter fly left
                        dc.b <SP_Dat_Plane_4c ; transporter fly right
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
SP_SpriteDatPtrHi_Plane dc.b >SP_Dat_Plane_00 ; plane single sprite phase 1
                        dc.b >SP_Dat_Plane_01 ; plane single sprite phase 2
                        dc.b >SP_Dat_Plane_02 ; plane single sprite phase 3
                        dc.b >SP_Dat_Plane_03 ; plane single sprite phase 4
                        dc.b >SP_Dat_Plane_04 ; plane single sprite phase 5
                        dc.b >SP_Dat_Plane_05 ; plane single sprite phase 6
                        dc.b >SP_Dat_Plane_06 ; plane single sprite phase 7
                        dc.b >SP_Dat_Plane_07 ; plane double sprite phase 1 left
                        dc.b >SP_Dat_Plane_08 ; plane double sprite phase 1 right
                        dc.b >SP_Dat_Plane_09 ; plane double sprite phase 2 left
                        dc.b >SP_Dat_Plane_0a ; plane double sprite phase 2 right
                        dc.b >SP_Dat_Plane_0b ; plane double sprite phase 3 left
                        dc.b >SP_Dat_Plane_0c ; plane double sprite phase 3 right
                        dc.b >SP_Dat_Plane_0d ; plane double sprite phase 4 left
                        dc.b >SP_Dat_Plane_0e ; plane double sprite phase 4 right
                        dc.b >SP_Dat_Plane_0f ; plane double sprite phase 5 left
                        dc.b >SP_Dat_Plane_10 ; plane double sprite phase 5 right
                        dc.b >SP_Dat_Plane_11 ; plane turn away mid phase 1 left
                        dc.b >SP_Dat_Plane_12 ; plane turn away mid phase 1 right
                        dc.b >SP_Dat_Plane_13 ; plane turn away mid phase 2 left
                        dc.b >SP_Dat_Plane_14 ; plane turn away mid phase 3 right
                        dc.b >SP_Dat_Plane_15 ; plane turn away mid phase 3 left
                        dc.b >SP_Dat_Plane_16 ; plane turn away mid phase 3 right
                        dc.b >SP_Dat_Plane_17 ; plane turn away left phase 1 left
                        dc.b >SP_Dat_Plane_18 ; plane turn away left phase 1 right
                        dc.b >SP_Dat_Plane_19 ; plane turn away left phase 2 left
                        dc.b >SP_Dat_Plane_1a ; plane turn away left phase 2 right
                        dc.b >SP_Dat_Plane_1b ; plane turn away left phase 3 left
                        dc.b >SP_Dat_Plane_1c ; plane turn away left phase 3 right
                        dc.b >SP_Dat_Plane_1d ; plane turn away right phase 1 left
                        dc.b >SP_Dat_Plane_1e ; plane turn away right phase 1 right
                        dc.b >SP_Dat_Plane_1f ; plane turn away right phase 2 left
                        dc.b >SP_Dat_Plane_20 ; plane turn away right phase 2 right
                        dc.b >SP_Dat_Plane_21 ; plane turn away right phase 3 left
                        dc.b >SP_Dat_Plane_22 ; plane turn away right phase 3 right
                        dc.b >SP_Dat_Plane_23 ; target cross
                        dc.b >SP_Dat_Plane_24 ; bullet phase  1 - max
                        dc.b >SP_Dat_Plane_25 ; bullet phase  2
                        dc.b >SP_Dat_Plane_26 ; bullet phase  3
                        dc.b >SP_Dat_Plane_27 ; bullet phase  4
                        dc.b >SP_Dat_Plane_28 ; bullet phase  5
                        dc.b >SP_Dat_Plane_29 ; bullet phase  6
                        dc.b >SP_Dat_Plane_2a ; bullet phase  7
                        dc.b >SP_Dat_Plane_2b ; bullet phase  8
                        dc.b >SP_Dat_Plane_2c ; bullet phase  9
                        dc.b >SP_Dat_Plane_2d ; bullet phase 10
                        dc.b >SP_Dat_Plane_2e ; bullet phase 11
                        dc.b >SP_Dat_Plane_2f ; bullet phase 12 - min
                        dc.b >SP_Dat_Plane_30 ; cannon move up max
                        dc.b >SP_Dat_Plane_31 ; cannon move down phase  1
                        dc.b >SP_Dat_Plane_32 ; cannon move down phase  2
                        dc.b >SP_Dat_Plane_33 ; cannon move down phase  3
                        dc.b >SP_Dat_Plane_34 ; cannon move down phase  4
                        dc.b >SP_Dat_Plane_35 ; cannon move down phase  5
                        dc.b >SP_Dat_Plane_36 ; cannon move down phase  6
                        dc.b >SP_Dat_Plane_37 ; cannon move down phase  7
                        dc.b >SP_Dat_Plane_38 ; cannon move down phase  8
                        dc.b >SP_Dat_Plane_39 ; cannon move down phase  9
                        dc.b >SP_Dat_Plane_3a ; cannon move down phase 10
                        dc.b >SP_Dat_Plane_3b ; cannon move down phase 11
                        dc.b >SP_Dat_Plane_3c ; cannon move down phase 12
                        dc.b >SP_Dat_Plane_3d ; cannon move down phase 13
                        dc.b >SP_Dat_Plane_3e ; cannon move down phase 14
                        dc.b >SP_Dat_Plane_3f ; cannon move down phase 15
                        dc.b >SP_Dat_Plane_40 ; cannon move down max
                        dc.b >SP_Dat_Plane_41 ; enemy shot min
                        dc.b >SP_Dat_Plane_42 ; enemy shot phase 1
                        dc.b >SP_Dat_Plane_43 ; enemy shot phase 2
                        dc.b >SP_Dat_Plane_44 ; enemy shot phase 3
                        dc.b >SP_Dat_Plane_45 ; enemy shot phase 4
                        dc.b >SP_Dat_Plane_46 ; enemy shot phase 5
                        dc.b >SP_Dat_Plane_47 ; enemy shot max
                        dc.b >SP_Dat_Plane_48 ; explode transporter
                        dc.b >SP_Dat_Plane_49 ; explode plane left
                        dc.b >SP_Dat_Plane_4a ; explode plane right
                        dc.b >SP_Dat_Plane_4b ; transporter fly left
                        dc.b >SP_Dat_Plane_4c ; transporter fly right
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
SP_SpriteDatPtrLo_Ship  dc.b <SP_Dat_Ship_00 ; target cross
                        dc.b <SP_Dat_Ship_01 ; cannon shot phase  1 - max
                        dc.b <SP_Dat_Ship_02 ; cannon shot phase  2
                        dc.b <SP_Dat_Ship_03 ; cannon shot phase  3
                        dc.b <SP_Dat_Ship_04 ; cannon shot phase  4
                        dc.b <SP_Dat_Ship_05 ; cannon shot phase  5
                        dc.b <SP_Dat_Ship_06 ; cannon shot phase  6
                        dc.b <SP_Dat_Ship_07 ; cannon shot phase  7
                        dc.b <SP_Dat_Ship_08 ; cannon shot phase  8
                        dc.b <SP_Dat_Ship_09 ; cannon shot phase  9
                        dc.b <SP_Dat_Ship_0a ; cannon shot phase 10
                        dc.b <SP_Dat_Ship_0b ; cannon shot phase 11
                        dc.b <SP_Dat_Ship_0c ; cannon shot phase 12 - min
                        dc.b <SP_Dat_Ship_0d ; cannon down  1 - max up
                        dc.b <SP_Dat_Ship_0e ; cannon down  2
                        dc.b <SP_Dat_Ship_0f ; cannon down  3
                        dc.b <SP_Dat_Ship_10 ; cannon down  4
                        dc.b <SP_Dat_Ship_11 ; cannon down  5
                        dc.b <SP_Dat_Ship_12 ; cannon down  6
                        dc.b <SP_Dat_Ship_13 ; cannon down  7
                        dc.b <SP_Dat_Ship_14 ; cannon down  8
                        dc.b <SP_Dat_Ship_15 ; cannon down  9
                        dc.b <SP_Dat_Ship_16 ; cannon down 10
                        dc.b <SP_Dat_Ship_17 ; cannon down 11
                        dc.b <SP_Dat_Ship_18 ; cannon down 12
                        dc.b <SP_Dat_Ship_19 ; cannon down 13
                        dc.b <SP_Dat_Ship_1a ; cannon down 14
                        dc.b <SP_Dat_Ship_1b ; cannon down 15
                        dc.b <SP_Dat_Ship_1c ; cannon down 16 - max down
                        dc.b <SP_Dat_Ship_1d ; enemy bullet phase 1 - min
                        dc.b <SP_Dat_Ship_1e ; enemy bullet phase 2
                        dc.b <SP_Dat_Ship_1f ; enemy bullet phase 3
                        dc.b <SP_Dat_Ship_20 ; enemy bullet phase 4
                        dc.b <SP_Dat_Ship_21 ; enemy bullet phase 5
                        dc.b <SP_Dat_Ship_22 ; enemy bullet phase 6 - max
                        dc.b <SP_Dat_Ship_23 ; explosion
                        dc.b <SP_Dat_Ship_24 ; water splash phase 1 - min
                        dc.b <SP_Dat_Ship_25 ; water splash phase 2
                        dc.b <SP_Dat_Ship_26 ; water splash phase 3 - max
                        dc.b <SP_Dat_Ship_27 ; enemy water splash phase  1 - start
                        dc.b <SP_Dat_Ship_28 ; enemy water splash phase  2
                        dc.b <SP_Dat_Ship_29 ; enemy water splash phase  3
                        dc.b <SP_Dat_Ship_2a ; enemy water splash phase  4
                        dc.b <SP_Dat_Ship_2b ; enemy water splash phase  5
                        dc.b <SP_Dat_Ship_2c ; enemy water splash phase  6
                        dc.b <SP_Dat_Ship_2d ; enemy water splash phase  7
                        dc.b <SP_Dat_Ship_2e ; enemy water splash phase  8
                        dc.b <SP_Dat_Ship_2f ; enemy water splash phase  9
                        dc.b <SP_Dat_Ship_30 ; enemy water splash phase 10
                        dc.b <SP_Dat_Ship_31 ; enemy water splash phase 11 - end
                        dc.b <SP_Dat_Ship_32 ; carrier nose
                        dc.b <SP_Dat_Ship_33 ; carrier mid
                        dc.b <SP_Dat_Ship_34 ; carrier rear
                        dc.b <SP_Dat_Ship_35 ; cover block
                        dc.b <SP_Dat_Ship_36 ; vessel 1
                        dc.b <SP_Dat_Ship_37 ; vessel 2
                        dc.b <SP_Dat_Ship_38 ; vessel 3
                        dc.b <SP_Dat_Ship_39 ; vessel 4
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
SP_SpriteDatPtrHi_Ship  dc.b >SP_Dat_Ship_00 ; target cross
                        dc.b >SP_Dat_Ship_01 ; cannon shot phase  1 - max
                        dc.b >SP_Dat_Ship_02 ; cannon shot phase  2
                        dc.b >SP_Dat_Ship_03 ; cannon shot phase  3
                        dc.b >SP_Dat_Ship_04 ; cannon shot phase  4
                        dc.b >SP_Dat_Ship_05 ; cannon shot phase  5
                        dc.b >SP_Dat_Ship_06 ; cannon shot phase  6
                        dc.b >SP_Dat_Ship_07 ; cannon shot phase  7
                        dc.b >SP_Dat_Ship_08 ; cannon shot phase  8
                        dc.b >SP_Dat_Ship_09 ; cannon shot phase  9
                        dc.b >SP_Dat_Ship_0a ; cannon shot phase 10
                        dc.b >SP_Dat_Ship_0b ; cannon shot phase 11
                        dc.b >SP_Dat_Ship_0c ; cannon shot phase 12 - min
                        dc.b >SP_Dat_Ship_0d ; cannon down  1 - max up
                        dc.b >SP_Dat_Ship_0e ; cannon down  2
                        dc.b >SP_Dat_Ship_0f ; cannon down  3
                        dc.b >SP_Dat_Ship_10 ; cannon down  4
                        dc.b >SP_Dat_Ship_11 ; cannon down  5
                        dc.b >SP_Dat_Ship_12 ; cannon down  6
                        dc.b >SP_Dat_Ship_13 ; cannon down  7
                        dc.b >SP_Dat_Ship_14 ; cannon down  8
                        dc.b >SP_Dat_Ship_15 ; cannon down  9
                        dc.b >SP_Dat_Ship_16 ; cannon down 10
                        dc.b >SP_Dat_Ship_17 ; cannon down 11
                        dc.b >SP_Dat_Ship_18 ; cannon down 12
                        dc.b >SP_Dat_Ship_19 ; cannon down 13
                        dc.b >SP_Dat_Ship_1a ; cannon down 14
                        dc.b >SP_Dat_Ship_1b ; cannon down 15
                        dc.b >SP_Dat_Ship_1c ; cannon down 16 - max down
                        dc.b >SP_Dat_Ship_1d ; enemy bullet phase 1 - min
                        dc.b >SP_Dat_Ship_1e ; enemy bullet phase 2
                        dc.b >SP_Dat_Ship_1f ; enemy bullet phase 3
                        dc.b >SP_Dat_Ship_20 ; enemy bullet phase 4
                        dc.b >SP_Dat_Ship_21 ; enemy bullet phase 5
                        dc.b >SP_Dat_Ship_22 ; enemy bullet phase 6 - max
                        dc.b >SP_Dat_Ship_23 ; explosion
                        dc.b >SP_Dat_Ship_24 ; water splash phase 1 - min
                        dc.b >SP_Dat_Ship_25 ; water splash phase 2
                        dc.b >SP_Dat_Ship_26 ; water splash phase 3 - max
                        dc.b >SP_Dat_Ship_27 ; enemy water splash phase  1 - start
                        dc.b >SP_Dat_Ship_28 ; enemy water splash phase  2
                        dc.b >SP_Dat_Ship_29 ; enemy water splash phase  3
                        dc.b >SP_Dat_Ship_2a ; enemy water splash phase  4
                        dc.b >SP_Dat_Ship_2b ; enemy water splash phase  5
                        dc.b >SP_Dat_Ship_2c ; enemy water splash phase  6
                        dc.b >SP_Dat_Ship_2d ; enemy water splash phase  7
                        dc.b >SP_Dat_Ship_2e ; enemy water splash phase  8
                        dc.b >SP_Dat_Ship_2f ; enemy water splash phase  9
                        dc.b >SP_Dat_Ship_30 ; enemy water splash phase 10
                        dc.b >SP_Dat_Ship_31 ; enemy water splash phase 11 - end  
                        dc.b >SP_Dat_Ship_32 ; carrier nose
                        dc.b >SP_Dat_Ship_33 ; carrier mid
                        dc.b >SP_Dat_Ship_34 ; carrier rear
                        dc.b >SP_Dat_Ship_35 ; cover block
                        dc.b >SP_Dat_Ship_36 ; vessel 1
                        dc.b >SP_Dat_Ship_37 ; vessel 2
                        dc.b >SP_Dat_Ship_38 ; vessel 3
                        dc.b >SP_Dat_Ship_39 ; vessel 4
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
SP_SpriteDatPtrLo_Beach dc.b <SP_Dat_Beach_00 ; explosion phase 1
                        dc.b <SP_Dat_Beach_01 ; my tank move left
                        dc.b <SP_Dat_Beach_02 ; my tank move up
                        dc.b <SP_Dat_Beach_03 ; my tank move down
                        dc.b <SP_Dat_Beach_04 ; shot left
                        dc.b <SP_Dat_Beach_05 ; shot right
                        dc.b <SP_Dat_Beach_06 ; cannon
                        dc.b <SP_Dat_Beach_07 ; enemy tank
                        dc.b <SP_Dat_Beach_08 ; machine gun
                        dc.b <SP_Dat_Beach_09 ; turret
                        dc.b <SP_Dat_Beach_0a ; score  200
                        dc.b <SP_Dat_Beach_0b ; score  400
                        dc.b <SP_Dat_Beach_0c ; score  600
                        dc.b <SP_Dat_Beach_0d ; score  800
                        dc.b <SP_Dat_Beach_0e ; score 1000
                        dc.b <SP_Dat_Beach_0f ; .hbu004. - explosion phase 2
                        dc.b <SP_Dat_Beach_10 ; .hbu004. - explosion phase 3
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
SP_SpriteDatPtrHi_Beach dc.b >SP_Dat_Beach_00 ; explosion phase 1
                        dc.b >SP_Dat_Beach_01 ; my tank move left
                        dc.b >SP_Dat_Beach_02 ; my tank move up
                        dc.b >SP_Dat_Beach_03 ; my tank move down
                        dc.b >SP_Dat_Beach_04 ; shot left
                        dc.b >SP_Dat_Beach_05 ; shot right
                        dc.b >SP_Dat_Beach_06 ; cannon
                        dc.b >SP_Dat_Beach_07 ; enemy tank
                        dc.b >SP_Dat_Beach_08 ; machine gun
                        dc.b >SP_Dat_Beach_09 ; turret
                        dc.b >SP_Dat_Beach_0a ; score  200
                        dc.b >SP_Dat_Beach_0b ; score  400
                        dc.b >SP_Dat_Beach_0c ; score  600
                        dc.b >SP_Dat_Beach_0d ; score  800
                        dc.b >SP_Dat_Beach_0e ; score 1000
                        dc.b >SP_Dat_Beach_0f ; .hbu004. - explosion phase 2
                        dc.b >SP_Dat_Beach_10 ; .hbu004. - explosion phase 3
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
SP_SpriteDatPtrLo_Hill  dc.b <SP_Dat_Hill_00 ; target cross
                        dc.b <SP_Dat_Hill_01 ; my cannon up max
                        dc.b <SP_Dat_Hill_02 ; my cannon down step  1
                        dc.b <SP_Dat_Hill_03 ; my cannon down step  2
                        dc.b <SP_Dat_Hill_04 ; my cannon down step  3
                        dc.b <SP_Dat_Hill_05 ; my cannon down step  4
                        dc.b <SP_Dat_Hill_06 ; my cannon down step  5
                        dc.b <SP_Dat_Hill_07 ; my cannon down step  6
                        dc.b <SP_Dat_Hill_08 ; my cannon down step  7
                        dc.b <SP_Dat_Hill_09 ; my cannon down step  8
                        dc.b <SP_Dat_Hill_0a ; my cannon down step  9
                        dc.b <SP_Dat_Hill_0b ; my cannon down step 10
                        dc.b <SP_Dat_Hill_0c ; my cannon down step 11
                        dc.b <SP_Dat_Hill_0d ; my cannon down step 12
                        dc.b <SP_Dat_Hill_0e ; my cannon down step 13
                        dc.b <SP_Dat_Hill_0f ; my cannon down step 14
                        dc.b <SP_Dat_Hill_10 ; my cannon down max
                        dc.b <SP_Dat_Hill_11 ; enemy cannon right step  1 - max left
                        dc.b <SP_Dat_Hill_12 ; enemy cannon right step  2
                        dc.b <SP_Dat_Hill_13 ; enemy cannon right step  3
                        dc.b <SP_Dat_Hill_14 ; enemy cannon right step  4
                        dc.b <SP_Dat_Hill_15 ; enemy cannon right step  5
                        dc.b <SP_Dat_Hill_16 ; enemy cannon right step  6
                        dc.b <SP_Dat_Hill_17 ; enemy cannon right step  7
                        dc.b <SP_Dat_Hill_18 ; enemy cannon right step  8
                        dc.b <SP_Dat_Hill_19 ; enemy cannon right step  9
                        dc.b <SP_Dat_Hill_1a ; enemy cannon right step 10
                        dc.b <SP_Dat_Hill_1b ; enemy cannon right step 11
                        dc.b <SP_Dat_Hill_1c ; enemy cannon right step 12
                        dc.b <SP_Dat_Hill_1d ; enemy cannon right step 13 - max/up max
                        dc.b <SP_Dat_Hill_1e ; enemy cannon down step 1 - up max
                        dc.b <SP_Dat_Hill_1f ; enemy cannon down step 2
                        dc.b <SP_Dat_Hill_20 ; enemy cannon down step 3
                        dc.b <SP_Dat_Hill_21 ; enemy cannon down step 4
                        dc.b <SP_Dat_Hill_22 ; enemy cannon down step 5
                        dc.b <SP_Dat_Hill_23 ; enemy cannon down step 6
                        dc.b <SP_Dat_Hill_24 ; enemy cannon down step 7
                        dc.b <SP_Dat_Hill_25 ; enemy cannon down step 8
                        dc.b <SP_Dat_Hill_26 ; enemy cannon down max
                        dc.b <SP_Dat_Hill_27 ; hill target
                        dc.b <SP_Dat_Hill_28 ; explosion hill target hit
                        dc.b <SP_Dat_Hill_29 ; explosion hill cap 1
                        dc.b <SP_Dat_Hill_2a ; explosion hill cap piece  1
                        dc.b <SP_Dat_Hill_2b ; explosion hill cap piece  2
                        dc.b <SP_Dat_Hill_2c ; explosion hill cap piece  3
                        dc.b <SP_Dat_Hill_2d ; explosion hill cap piece  4
                        dc.b <SP_Dat_Hill_2e ; explosion hill cap piece  5
                        dc.b <SP_Dat_Hill_2f ; explosion hill cap piece  6
                        dc.b <SP_Dat_Hill_30 ; explosion hill cap piece  7
                        dc.b <SP_Dat_Hill_31 ; explosion hill cap piece  8
                        dc.b <SP_Dat_Hill_32 ; explosion hill cap piece  9
                        dc.b <SP_Dat_Hill_33 ; explosion hill cap piece 10
                        dc.b <SP_Dat_Hill_34 ; explosion hill cap piece 11
                        dc.b <SP_Dat_Hill_35 ; explosion hill cap piece 12
                        dc.b <SP_Dat_Hill_36 ; explosion hill cap piece 13
                        dc.b <SP_Dat_Hill_37 ; explosion hill cap piece 14
                        dc.b <SP_Dat_Hill_38 ; explosion hill cap piece 15
                        dc.b <SP_Dat_Hill_39 ; explosion hill cap piece 16
                        dc.b <SP_Dat_Hill_3a ; explosion hill cap piece 17
                        dc.b <SP_Dat_Hill_3b ; explosion hill cap piece 18
                        dc.b <SP_Dat_Hill_3c ; explosion hill cap piece 19
                        dc.b <SP_Dat_Hill_3d ; explosion hill cap piece 10
                        dc.b <SP_Dat_Hill_3e ; wave white flag right step 1 - max left
                        dc.b <SP_Dat_Hill_3f ; wave white flag right step 2
                        dc.b <SP_Dat_Hill_40 ; wave white flag right step 3
                        dc.b <SP_Dat_Hill_41 ; wave white flag left step 1 - max right
                        dc.b <SP_Dat_Hill_42 ; wave white flag left step 2
                        dc.b <SP_Dat_Hill_43 ; wave white flag left step 3
                        dc.b <SP_Dat_Hill_44 ; explosion hill cap 2
                        dc.b <SP_Dat_Hill_45 ; enemy bullet phase 1 - min
                        dc.b <SP_Dat_Hill_46 ; enemy bullet phase 2
                        dc.b <SP_Dat_Hill_47 ; enemy bullet phase 3
                        dc.b <SP_Dat_Hill_48 ; enemy bullet phase 4
                        dc.b <SP_Dat_Hill_49 ; enemy bullet phase 5
                        dc.b <SP_Dat_Hill_4a ; enemy bullet phase 6
                        dc.b <SP_Dat_Hill_4b ; enemy bullet phase 7
                        dc.b <SP_Dat_Hill_4c ; enemy bullet phase 8
                        dc.b <SP_Dat_Hill_4d ; enemy bullet phase 9 - max
                        dc.b <SP_Dat_Hill_4e ; my bullet phase 1 - min
                        dc.b <SP_Dat_Hill_4f ; my bullet phase 2
                        dc.b <SP_Dat_Hill_50 ; my bullet phase 3
                        dc.b <SP_Dat_Hill_51 ; my bullet phase 4
                        dc.b <SP_Dat_Hill_52 ; my bullet phase 5
                        dc.b <SP_Dat_Hill_53 ; my bullet phase 6
                        dc.b <SP_Dat_Hill_54 ; my bullet phase 7
                        dc.b <SP_Dat_Hill_55 ; my bullet phase 8 - max
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
SP_SpriteDatPtrHi_Hill  dc.b >SP_Dat_Hill_00 ; target cross
                        dc.b >SP_Dat_Hill_01 ; my cannon up max
                        dc.b >SP_Dat_Hill_02 ; my cannon down step  1
                        dc.b >SP_Dat_Hill_03 ; my cannon down step  2
                        dc.b >SP_Dat_Hill_04 ; my cannon down step  3
                        dc.b >SP_Dat_Hill_05 ; my cannon down step  4
                        dc.b >SP_Dat_Hill_06 ; my cannon down step  5
                        dc.b >SP_Dat_Hill_07 ; my cannon down step  6
                        dc.b >SP_Dat_Hill_08 ; my cannon down step  7
                        dc.b >SP_Dat_Hill_09 ; my cannon down step  8
                        dc.b >SP_Dat_Hill_0a ; my cannon down step  9
                        dc.b >SP_Dat_Hill_0b ; my cannon down step 10
                        dc.b >SP_Dat_Hill_0c ; my cannon down step 11
                        dc.b >SP_Dat_Hill_0d ; my cannon down step 12
                        dc.b >SP_Dat_Hill_0e ; my cannon down step 13
                        dc.b >SP_Dat_Hill_0f ; my cannon down step 14
                        dc.b >SP_Dat_Hill_10 ; my cannon down max
                        dc.b >SP_Dat_Hill_11 ; enemy cannon right step  1 - max left
                        dc.b >SP_Dat_Hill_12 ; enemy cannon right step  2
                        dc.b >SP_Dat_Hill_13 ; enemy cannon right step  3
                        dc.b >SP_Dat_Hill_14 ; enemy cannon right step  4
                        dc.b >SP_Dat_Hill_15 ; enemy cannon right step  5
                        dc.b >SP_Dat_Hill_16 ; enemy cannon right step  6
                        dc.b >SP_Dat_Hill_17 ; enemy cannon right step  7
                        dc.b >SP_Dat_Hill_18 ; enemy cannon right step  8
                        dc.b >SP_Dat_Hill_19 ; enemy cannon right step  9
                        dc.b >SP_Dat_Hill_1a ; enemy cannon right step 10
                        dc.b >SP_Dat_Hill_1b ; enemy cannon right step 11
                        dc.b >SP_Dat_Hill_1c ; enemy cannon right step 12
                        dc.b >SP_Dat_Hill_1d ; enemy cannon right step 13 - max/up max
                        dc.b >SP_Dat_Hill_1e ; enemy cannon down step 1 - up max
                        dc.b >SP_Dat_Hill_1f ; enemy cannon down step 2
                        dc.b >SP_Dat_Hill_20 ; enemy cannon down step 3
                        dc.b >SP_Dat_Hill_21 ; enemy cannon down step 4
                        dc.b >SP_Dat_Hill_22 ; enemy cannon down step 5
                        dc.b >SP_Dat_Hill_23 ; enemy cannon down step 6
                        dc.b >SP_Dat_Hill_24 ; enemy cannon down step 7
                        dc.b >SP_Dat_Hill_25 ; enemy cannon down step 8
                        dc.b >SP_Dat_Hill_26 ; enemy cannon down max
                        dc.b >SP_Dat_Hill_27 ; hill target
                        dc.b >SP_Dat_Hill_28 ; explosion hill target hit
                        dc.b >SP_Dat_Hill_29 ; explosion hill cap 1
                        dc.b >SP_Dat_Hill_2a ; explosion hill cap piece  1
                        dc.b >SP_Dat_Hill_2b ; explosion hill cap piece  2
                        dc.b >SP_Dat_Hill_2c ; explosion hill cap piece  3
                        dc.b >SP_Dat_Hill_2d ; explosion hill cap piece  4
                        dc.b >SP_Dat_Hill_2e ; explosion hill cap piece  5
                        dc.b >SP_Dat_Hill_2f ; explosion hill cap piece  6
                        dc.b >SP_Dat_Hill_30 ; explosion hill cap piece  7
                        dc.b >SP_Dat_Hill_31 ; explosion hill cap piece  8
                        dc.b >SP_Dat_Hill_32 ; explosion hill cap piece  9
                        dc.b >SP_Dat_Hill_33 ; explosion hill cap piece 10
                        dc.b >SP_Dat_Hill_34 ; explosion hill cap piece 11
                        dc.b >SP_Dat_Hill_35 ; explosion hill cap piece 12
                        dc.b >SP_Dat_Hill_36 ; explosion hill cap piece 13
                        dc.b >SP_Dat_Hill_37 ; explosion hill cap piece 14
                        dc.b >SP_Dat_Hill_38 ; explosion hill cap piece 15
                        dc.b >SP_Dat_Hill_39 ; explosion hill cap piece 16
                        dc.b >SP_Dat_Hill_3a ; explosion hill cap piece 17
                        dc.b >SP_Dat_Hill_3b ; explosion hill cap piece 18
                        dc.b >SP_Dat_Hill_3c ; explosion hill cap piece 19
                        dc.b >SP_Dat_Hill_3d ; explosion hill cap piece 10
                        dc.b >SP_Dat_Hill_3e ; wave white flag right step 1 - max left
                        dc.b >SP_Dat_Hill_3f ; wave white flag right step 2
                        dc.b >SP_Dat_Hill_40 ; wave white flag right step 3
                        dc.b >SP_Dat_Hill_41 ; wave white flag left step 1 - max right
                        dc.b >SP_Dat_Hill_42 ; wave white flag left step 2
                        dc.b >SP_Dat_Hill_43 ; wave white flag left step 3
                        dc.b >SP_Dat_Hill_44 ; explosion hill cap 2
                        dc.b >SP_Dat_Hill_45 ; enemy bullet phase 1 - min
                        dc.b >SP_Dat_Hill_46 ; enemy bullet phase 2
                        dc.b >SP_Dat_Hill_47 ; enemy bullet phase 3
                        dc.b >SP_Dat_Hill_48 ; enemy bullet phase 4
                        dc.b >SP_Dat_Hill_49 ; enemy bullet phase 5
                        dc.b >SP_Dat_Hill_4a ; enemy bullet phase 6
                        dc.b >SP_Dat_Hill_4b ; enemy bullet phase 7
                        dc.b >SP_Dat_Hill_4c ; enemy bullet phase 8
                        dc.b >SP_Dat_Hill_4d ; enemy bullet phase 9 - max
                        dc.b >SP_Dat_Hill_4e ; my bullet phase 1 - min
                        dc.b >SP_Dat_Hill_4f ; my bullet phase 2
                        dc.b >SP_Dat_Hill_50 ; my bullet phase 3
                        dc.b >SP_Dat_Hill_51 ; my bullet phase 4
                        dc.b >SP_Dat_Hill_52 ; my bullet phase 5
                        dc.b >SP_Dat_Hill_53 ; my bullet phase 6
                        dc.b >SP_Dat_Hill_54 ; my bullet phase 7
                        dc.b >SP_Dat_Hill_55 ; my bullet phase 8 - max
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_00         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1f ; 
                        dc.b $18 ; ...##...  ; ...........##...........
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_01         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1f ; 
                        dc.b $3c ; ..####.. ; ..........####..........
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_02         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1c ;          ; ...........##...........
                        dc.b $18 ; ...##... ; .........######.........
                        dc.b $1f ; 
                        dc.b $7e ; .######.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_03         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1c ;          ; ...........##...........
                        dc.b $18 ; ...##... ; .......##########.......
                        dc.b $1e ; 
                        dc.b $01 ; .......#
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_04         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1c ;          ; ...........##...........
                        dc.b $18 ; ...##... ; .....##############.....
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $e0 ; ###.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_05         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ...........##...........
                        dc.b $1c ;          ; ...########..########...
                        dc.b $18 ; ...##... ; .......##......##.......
                        dc.b $1e ; 
                        dc.b $1f ; ...#####
                        dc.b $1f ; 
                        dc.b $e7 ; ###..###
                        dc.b $20 ; 
                        dc.b $f8 ; #####...
                        dc.b $21 ; 
                        dc.b $01 ; .......#
                        dc.b $22 ; 
                        dc.b $81 ; #......#
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_06         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ...........##...........
                        dc.b $1c ;          ; .##########..##########.
                        dc.b $18 ; ...##... ; ......##........##......
                        dc.b $1e ; 
                        dc.b $7f ; .#######
                        dc.b $1f ; 
                        dc.b $e7 ; ###..###
                        dc.b $20 ; 
                        dc.b $fe ; #######.
                        dc.b $21 ; 
                        dc.b $03 ; ......##
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_07         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $17 ;          ; ...............##...............
                        dc.b $01 ; .......# ; ...............##...............
                        dc.b $1a ;          ; ..............####..............
                        dc.b $01 ; .......# ; ...###########...###########...
                        dc.b $1d ;          ; .........##.........###........
                        dc.b $03 ; ......##
                        dc.b $1f ; 
                        dc.b $1f ; ...#####
                        dc.b $20 ; 
                        dc.b $fc ; ######..
                        dc.b $23 ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_08         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ; 
                        dc.b $80 ; #.......
                        dc.b $18 ; 
                        dc.b $80 ; #.......
                        dc.b $1b ; 
                        dc.b $c0 ; ##......
                        dc.b $1e ; 
                        dc.b $3f ; ..######
                        dc.b $1f ; 
                        dc.b $f8 ; #####...
                        dc.b $21 ; 
                        dc.b $07 ; .....###
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_09         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $17 ;          ; ...............##...............
                        dc.b $01 ; .......# ; ...............##...............
                        dc.b $1a ;          ; .............######.............
                        dc.b $01 ; .......# ; .############..##..############.
                        dc.b $1d ;          ; ........##............##........
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $7f ; .#######
                        dc.b $20 ; 
                        dc.b $f9 ; #####..#
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_0a         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ; 
                        dc.b $80 ; #.......
                        dc.b $18 ; 
                        dc.b $80 ; #.......
                        dc.b $1b ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $9f ; #..#####
                        dc.b $1f ; 
                        dc.b $fe ; #######.
                        dc.b $21 ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_0b         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $14 ;          ; .......................##.......................
                        dc.b $01 ; .......# ; .....................#.##.#.....................
                        dc.b $17 ;          ; .......................##.......................
                        dc.b $05 ; .....#.# ; .....................######.....................
                        dc.b $1a ;          ; .......##############..##..##############.......
                        dc.b $01 ; .......# ; ...............##..............##...............
                        dc.b $1d ; 
                        dc.b $07 ; .....###
                        dc.b $1e ; 
                        dc.b $01 ; .......#
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f9 ; #####..#
                        dc.b $22 ; 
                        dc.b $01 ; .......#
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_0c         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $12 ; 
                        dc.b $80 ; #.......
                        dc.b $15 ; 
                        dc.b $a0 ; #.#.....
                        dc.b $18 ; 
                        dc.b $80 ; #.......
                        dc.b $1b ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $9f ; #..#####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $21 ; 
                        dc.b $01 ; .......#
                        dc.b $22 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_0d         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $14 ;          ; .......................##.......................
                        dc.b $01 ; .......# ; .....................#.##.#.....................
                        dc.b $17 ;          ; .......................##.......................
                        dc.b $05 ; .....#.# ; ....................########....................
                        dc.b $1a ;          ; .....###############...##...###############.....
                        dc.b $01 ; .......# ; ..............##................##..............
                        dc.b $1d ;         
                        dc.b $0f ; ....####
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f1 ; ####...#
                        dc.b $22 ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_0e         dc.b $40 ; <flag: partial sprite data>
                        
;                        dc.b $0f ; 
;                        dc.b $80 ; #.......
                        dc.b $12 ; 
                        dc.b $80 ; #.......
                        dc.b $15 ; 
                        dc.b $a0 ; #.#.....
                        dc.b $18 ; 
                        dc.b $80 ; #.......
                        dc.b $1b ; 
                        dc.b $f0 ; ####....
                        dc.b $1e ; 
                        dc.b $8f ; #...####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $e0 ; ###.....
                        dc.b $22 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_0f         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $11 ;          ; .......................##.......................
                        dc.b $01 ; .......# ; ....................##.##.##....................
                        dc.b $14 ;          ; .......................##.......................
                        dc.b $0d ; ....##.# ; ......................####......................
                        dc.b $17 ;          ; ...................##########...................
                        dc.b $01 ; .......# ; ...#################...##...#################...
                        dc.b $1a ;          ; .............##..................##.............
                        dc.b $03 ; ......##
                        dc.b $1d ; 
                        dc.b $1f ; ...#####
                        dc.b $1e ; 
                        dc.b $1f ; ...#####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f1 ; ####...#
                        dc.b $22 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_10         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0f ; 
                        dc.b $80 ; #.......
                        dc.b $12 ; 
                        dc.b $b0 ; #.##....
                        dc.b $15 ; 
                        dc.b $80 ; #.......
                        dc.b $18 ; 
                        dc.b $c0 ; ##......
                        dc.b $1b ; 
                        dc.b $f8 ; #####...
                        dc.b $1e ; 
                        dc.b $8f ; #...####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f8 ; #####...
                        dc.b $22 ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_11         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $14 ;          ; .......................##.......................
                        dc.b $01 ; .......# ; ....................#.####.#....................
                        dc.b $17 ;          ; ......................####......................
                        dc.b $0b ; ....#.## ; ...................##########...................
                        dc.b $1a ;          ; ...##########################################...
                        dc.b $03 ; ......## ; ........############...##...############........
                        dc.b $1d ;          ; .............##..................##.............
                        dc.b $1f ; ...#####
                        dc.b $1e ; 
                        dc.b $1f ; ...#####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $ff ; ########
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $f1 ; ####...#
                        dc.b $25 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_12         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $12 ; 
                        dc.b $80 ; #.......
                        dc.b $15 ; 
                        dc.b $d0 ; ##.#....
                        dc.b $18 ; 
                        dc.b $c0 ; ##......
                        dc.b $1b ; 
                        dc.b $f8 ; #####...
                        dc.b $1e ; 
                        dc.b $ff ; ########
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f8 ; #####...
                        dc.b $21 ; 
                        dc.b $8f ; #...####
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $25 ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_13         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0e ;           ; .......................##.......................
                        dc.b $01 ; .......#  ; .......................##.......................
                        dc.b $11 ;           ; ......................####......................
                        dc.b $01 ; .......#  ; ......................####......................
                        dc.b $14 ;           ; .....................######.....................
                        dc.b $03 ; ......##  ; .............#.....##########.....#.............
                        dc.b $17 ;           ; ...##########################################...
                        dc.b $03 ; ......##  ; .....###############..####..###############.....
                        dc.b $1a ;           ; .............##........##........##.............
                        dc.b $07 ; .....###
                        dc.b $1c ; 
                        dc.b $04 ; .....#..
                        dc.b $1d ; 
                        dc.b $1f ; ...#####
                        dc.b $1e ; 
                        dc.b $1f ; ...#####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $ff ; ########
                        dc.b $21 ; 
                        dc.b $07 ; .....###
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $f3 ; ####..##
                        dc.b $25 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $01 ; .......#
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_14         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0c ; 
                        dc.b $80 ; #.......
                        dc.b $0f ; 
                        dc.b $80 ; #.......
                        dc.b $12 ; 
                        dc.b $c0 ; ##......
                        dc.b $15 ; 
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $e0 ; ###.....
                        dc.b $1b ; 
                        dc.b $f8 ; #####...
                        dc.b $1c ; 
                        dc.b $20 ; ..#.....
                        dc.b $1e ; 
                        dc.b $ff ; ########
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f8 ; #####...
                        dc.b $21 ; 
                        dc.b $cf ; ##..####
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $e0 ; ###.....
                        dc.b $24 ; 
                        dc.b $80 ; #.......
                        dc.b $25 ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_15         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $08 ;          ; .......................##.......................
                        dc.b $01 ; .......# ; .......................##.......................
                        dc.b $0b ;          ; ......................####......................
                        dc.b $01 ; .......# ; ......................####......................
                        dc.b $0e ;          ; ......................####......................
                        dc.b $03 ; ......## ; .....................######.....................
                        dc.b $11 ;          ; ............##.....##########.....##............
                        dc.b $03 ; ......## ; ...##########################################...
                        dc.b $14 ;          ; ....#################.####.#################....
                        dc.b $03 ; ......## ; ......#############...####...#############......
                        dc.b $17 ;          ; .............##.....#..##..#.....##.............
                        dc.b $07 ; .....### ; .......................##.......................
                        dc.b $19 ; 
                        dc.b $0c ; ....##..
                        dc.b $1a ; 
                        dc.b $1f ; ...#####
                        dc.b $1b ; 
                        dc.b $1f ; ...#####
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $ff ; ########
                        dc.b $1e ; 
                        dc.b $0f ; ....####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $fb ; #####.##
                        dc.b $21 ; 
                        dc.b $03 ; ......##
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $e3 ; ###...##
                        dc.b $25 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $09 ; ....#..#
                        dc.b $29 ; 
                        dc.b $01 ; .......#
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_16         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $06 ; 
                        dc.b $80 ; #.......
                        dc.b $09 ; 
                        dc.b $80 ; #.......
                        dc.b $0c ; 
                        dc.b $c0 ; ##......
                        dc.b $0f ; 
                        dc.b $c0 ; ##......
                        dc.b $12 ; 
                        dc.b $c0 ; ##......
                        dc.b $15 ; 
                        dc.b $e0 ; ###.....
                        dc.b $18 ; 
                        dc.b $f8 ; #####...
                        dc.b $19 ; 
                        dc.b $30 ; ..##....
                        dc.b $1b ; 
                        dc.b $ff ; ########
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $f8 ; #####...
                        dc.b $1e ; 
                        dc.b $df ; ##.#####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f0 ; ####....
                        dc.b $21 ; 
                        dc.b $c7 ; ##...###
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $24 ; 
                        dc.b $90 ; #..#....
                        dc.b $25 ; 
                        dc.b $60 ; .##.....
                        dc.b $27 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_17         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $11 ;          ; ..........................................###...
                        dc.b $03 ; ......## ; ........................................###.....
                        dc.b $14 ;          ; ......................##............#####.......
                        dc.b $03 ; ......## ; ......................###.......######..........
                        dc.b $17 ;          ; ......................############..............
                        dc.b $03 ; ......## ; ......................##########................
                        dc.b $1a ;          ; ....................#######.....................
                        dc.b $03 ; ......## ; ..................########......................
                        dc.b $1d ;          ; ................######..........................
                        dc.b $0f ; ....#### ; ............########............................
                        dc.b $20 ;          ; ........######..................................
                        dc.b $3f ; ..###### ; .....#####......................................
                        dc.b $23 ; 
                        dc.b $fc ; ######..
                        dc.b $25 ; 
                        dc.b $0f ; ....####
                        dc.b $26 ; 
                        dc.b $f0 ; ####....
                        dc.b $28 ; 
                        dc.b $fc ; ######..
                        dc.b $2a ; 
                        dc.b $07 ; .....###
                        dc.b $2b ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_18         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0b ; 
                        dc.b $38 ; ..###...
                        dc.b $0e ; 
                        dc.b $e0 ; ###.....
                        dc.b $10 ; 
                        dc.b $0f ; ....####
                        dc.b $11 ; 
                        dc.b $80 ; #.......
                        dc.b $12 ; 
                        dc.b $80 ; #.......
                        dc.b $13 ; 
                        dc.b $fc ; ######..
                        dc.b $15 ; 
                        dc.b $ff ; ########
                        dc.b $16 ; 
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $ff ; ########
                        dc.b $1b ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_19         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $11 ;          ; .........................................##.....
                        dc.b $1c ; ...###.. ; .......................................####.....
                        dc.b $14 ;          ; ....................................######......
                        dc.b $1e ; ...####. ; ..............................##..#######.......
                        dc.b $17 ;          ; ...................###.........#########........
                        dc.b $0f ; ....#### ; ...................####......#########..........
                        dc.b $1a ;          ; ....................#####.##########............
                        dc.b $0f ; ....#### ; ....................#############.##............
                        dc.b $1d ;          ; .....................##########.................
                        dc.b $07 ; .....### ; ...................##########...................
                        dc.b $20 ;          ; ..................##########....................
                        dc.b $1f ; ...##### ; .............##.#############...................
                        dc.b $23 ;          ; ..............#########...###...................
                        dc.b $3f ; ..###### ; ............#########...........................
                        dc.b $25 ;          ; ..........#########.............................
                        dc.b $06 ; .....##. ; ........########..##............................
                        dc.b $26 ;          ; ......#######...................................
                        dc.b $ff ; ######## ; .....#####......................................
                        dc.b $28 ; 
                        dc.b $03 ; ......##
                        dc.b $29 ; 
                        dc.b $fe ; #######.
                        dc.b $2b ; 
                        dc.b $0f ; ....####
                        dc.b $2c ; 
                        dc.b $f8 ; #####...
                        dc.b $2e ; 
                        dc.b $3f ; ..######
                        dc.b $2f ; 
                        dc.b $e0 ; ###.....
                        dc.b $31 ; 
                        dc.b $ff ; ########
                        dc.b $32 ; 
                        dc.b $30 ; ..##....
                        dc.b $33 ; 
                        dc.b $03 ; ......##
                        dc.b $34 ; 
                        dc.b $f8 ; #####...
                        dc.b $36 ; 
                        dc.b $07 ; .....###
                        dc.b $37 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_1a         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $05 ; 
                        dc.b $60 ; .##.....
                        dc.b $07 ; 
                        dc.b $01 ; .......#
                        dc.b $08 ; 
                        dc.b $e0 ; ###.....
                        dc.b $0a ; 
                        dc.b $0f ; ....####
                        dc.b $0b ; 
                        dc.b $c0 ; ##......
                        dc.b $0c ; 
                        dc.b $03 ; ......##
                        dc.b $0d ; 
                        dc.b $3f ; ..######
                        dc.b $0e ; 
                        dc.b $80 ; #.......
                        dc.b $0f ; 
                        dc.b $01 ; .......#
                        dc.b $10 ; 
                        dc.b $ff ; ########
                        dc.b $12 ; 
                        dc.b $07 ; .....###
                        dc.b $13 ; 
                        dc.b $fc ; ######..
                        dc.b $15 ; 
                        dc.b $bf ; #.######
                        dc.b $16 ; 
                        dc.b $f0 ; ####....
                        dc.b $18 ; 
                        dc.b $ff ; ########
                        dc.b $19 ; 
                        dc.b $b0 ; #.##....
                        dc.b $1b ; 
                        dc.b $fe ; #######.
                        dc.b $1e ; 
                        dc.b $f8 ; #####...
                        dc.b $21 ; 
                        dc.b $f0 ; ####....
                        dc.b $24 ; 
                        dc.b $f8 ; #####...
                        dc.b $27 ; 
                        dc.b $38 ; ..###...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_1b         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0e ;          ; .......................................##.......
                        dc.b $38 ; ..###... ; .....................................####.......
                        dc.b $11 ;          ; ....................................#####.......
                        dc.b $3c ; ..####.. ; ..............................##..######........
                        dc.b $14 ;          ; ..................###..........########.........
                        dc.b $1e ; ...####. ; ..................####.........#######..........
                        dc.b $17 ;          ; ...................####......########...........
                        dc.b $0f ; ....#### ; ....................#####..#########............
                        dc.b $1a ;          ; .....................#############.##...........
                        dc.b $07 ; .....### ; .....................###########................
                        dc.b $1d ;          ; ......................########..................
                        dc.b $07 ; .....### ; ....................#########..##...............
                        dc.b $20 ;          ; ...............##..###########..................
                        dc.b $03 ; ......## ; ................##########.####.................
                        dc.b $23 ;          ; ...............#########....###.................
                        dc.b $0f ; ....#### ; ..............#########..##.....................
                        dc.b $25 ;          ; .............#########..........................
                        dc.b $01 ; .......# ; ...........########..##.........................
                        dc.b $26 ;          ; ..........#######...............................
                        dc.b $9f ; #..##### ; .........#####..................................
                        dc.b $29 ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $01 ; .......#
                        dc.b $2c ; 
                        dc.b $ff ; ########
                        dc.b $2e ; 
                        dc.b $03 ; ......##
                        dc.b $2f ; 
                        dc.b $fe ; #######.
                        dc.b $31 ; 
                        dc.b $07 ; .....###
                        dc.b $32 ; 
                        dc.b $fc ; ######..
                        dc.b $34 ; 
                        dc.b $1f ; ...#####
                        dc.b $35 ; 
                        dc.b $e6 ; ###..##.
                        dc.b $37 ; 
                        dc.b $3f ; ..######
                        dc.b $38 ; 
                        dc.b $80 ; #.......
                        dc.b $3a ; 
                        dc.b $7c ; .#####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_1c         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $01 ; 
                        dc.b $01 ; .......#
                        dc.b $02 ; 
                        dc.b $80 ; #.......
                        dc.b $04 ; 
                        dc.b $07 ; .....###
                        dc.b $05 ; 
                        dc.b $80 ; #.......
                        dc.b $07 ; 
                        dc.b $0f ; ....####
                        dc.b $08 ; 
                        dc.b $80 ; #.......
                        dc.b $09 ; 
                        dc.b $03 ; ......##
                        dc.b $0a ; 
                        dc.b $3f ; ..######
                        dc.b $0c ; 
                        dc.b $01 ; .......#
                        dc.b $0d ; 
                        dc.b $fe ; #######.
                        dc.b $0f ; 
                        dc.b $01 ; .......#
                        dc.b $10 ; 
                        dc.b $fc ; ######..
                        dc.b $12 ; 
                        dc.b $07 ; .....###
                        dc.b $13 ; 
                        dc.b $f8 ; #####...
                        dc.b $15 ; 
                        dc.b $9f ; #..#####
                        dc.b $16 ; 
                        dc.b $f0 ; ####....
                        dc.b $18 ; 
                        dc.b $ff ; ########
                        dc.b $19 ; 
                        dc.b $d8 ; ##.##...
                        dc.b $1b ; 
                        dc.b $ff ; ########
                        dc.b $1e ; 
                        dc.b $fc ; ######..
                        dc.b $21 ; 
                        dc.b $f9 ; #####..#
                        dc.b $22 ; 
                        dc.b $80 ; #.......
                        dc.b $24 ; 
                        dc.b $fc ; ######..
                        dc.b $27 ; 
                        dc.b $de ; ##.####.
                        dc.b $2a ; 
                        dc.b $0e ; ....###.
                        dc.b $2d ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_1d         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $09 ;          ; ...###..........................................
                        dc.b $1c ; ...###.. ; .....###........................................
                        dc.b $0c ;          ; .......#####............##......................
                        dc.b $07 ; .....### ; .........######.......####......................
                        dc.b $0f ;          ; .............#############......................
                        dc.b $01 ; .......# ; ................##########......................
                        dc.b $10 ;          ; .....................#######....................
                        dc.b $f0 ; ####.... ; ......................########..................
                        dc.b $13 ;          ; ..........................######................
                        dc.b $7e ; .######. ; ............................########............
                        dc.b $14 ;          ; ..................................######........
                        dc.b $03 ; ......## ; ......................................######....
                        dc.b $16 ; 
                        dc.b $07 ; .....###
                        dc.b $17 ; 
                        dc.b $ff ; ########
                        dc.b $1a ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $07 ; .....###
                        dc.b $20 ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_1e         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0f ; 
                        dc.b $c0 ; ##......
                        dc.b $12 ; 
                        dc.b $c0 ; ##......
                        dc.b $15 ; 
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $c0 ; ##......
                        dc.b $1b ; 
                        dc.b $f0 ; ####....
                        dc.b $1e ; 
                        dc.b $fc ; ######..
                        dc.b $21 ; 
                        dc.b $3f ; ..######
                        dc.b $24 ; 
                        dc.b $0f ; ....####
                        dc.b $25 ; 
                        dc.b $f0 ; ####....
                        dc.b $28 ; 
                        dc.b $3f ; ..######
                        dc.b $2b ; 
                        dc.b $03 ; ......##
                        dc.b $2c ; 
                        dc.b $f0 ; ####....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_1f         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $03 ;          ; .....##.........................................
                        dc.b $06 ; .....##. ; .....####.......................................
                        dc.b $06 ;          ; ......######....................................
                        dc.b $07 ; .....### ; .......#######..##..............................
                        dc.b $07 ;          ; ........#########.........###...................
                        dc.b $80 ; #....... ; ..........#########......####...................
                        dc.b $09 ;          ; ............##########.#####....................
                        dc.b $03 ; ......## ; ............##.#############....................
                        dc.b $0a ;          ; .................##########.....................
                        dc.b $f0 ; ####.... ; ...................##########...................
                        dc.b $0c ;          ; ....................##########..................
                        dc.b $01 ; .......# ; ...................#############.##.............
                        dc.b $0d ;          ; ...................###...#########..............
                        dc.b $fc ; ######.. ; ...........................#########............
                        dc.b $0e ;          ; .............................#########..........
                        dc.b $c0 ; ##...... ; ............................##..########........
                        dc.b $10 ;          ; ...................................#######......
                        dc.b $ff ; ######## ; ......................................#####.....
                        dc.b $11 ; 
                        dc.b $80 ; #.......
                        dc.b $13 ; 
                        dc.b $3f ; ..######
                        dc.b $14 ; 
                        dc.b $e0 ; ###.....
                        dc.b $16 ; 
                        dc.b $0f ; ....####
                        dc.b $17 ; 
                        dc.b $fd ; ######.#
                        dc.b $19 ; 
                        dc.b $0d ; ....##.#
                        dc.b $1a ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $7f ; .#######
                        dc.b $20 ; 
                        dc.b $1f ; ...#####
                        dc.b $23 ; 
                        dc.b $0f ; ....####
                        dc.b $26 ; 
                        dc.b $1f ; ...#####
                        dc.b $29 ; 
                        dc.b $1c ; ...###..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_20         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0f ; 
                        dc.b $38 ; ..###...
                        dc.b $12 ; 
                        dc.b $78 ; .####...
                        dc.b $15 ; 
                        dc.b $f0 ; ####....
                        dc.b $18 ; 
                        dc.b $f0 ; ####....
                        dc.b $1b ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $f8 ; #####...
                        dc.b $21 ; 
                        dc.b $fc ; ######..
                        dc.b $24 ; 
                        dc.b $ff ; ########
                        dc.b $25 ; 
                        dc.b $60 ; .##.....
                        dc.b $27 ; 
                        dc.b $7f ; .#######
                        dc.b $28 ; 
                        dc.b $c0 ; ##......
                        dc.b $2a ; 
                        dc.b $1f ; ...#####
                        dc.b $2b ; 
                        dc.b $f0 ; ####....
                        dc.b $2d ; 
                        dc.b $07 ; .....###
                        dc.b $2e ; 
                        dc.b $fc ; ######..
                        dc.b $30 ; 
                        dc.b $0c ; ....##..
                        dc.b $31 ; 
                        dc.b $ff ; ########
                        dc.b $34 ; 
                        dc.b $1f ; ...#####
                        dc.b $35 ; 
                        dc.b $c0 ; ##......
                        dc.b $37 ; 
                        dc.b $03 ; ......##
                        dc.b $38 ; 
                        dc.b $e0 ; ###.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_21         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $00 ;          ; .......##.......................................
                        dc.b $01 ; .......# ; .......####.....................................
                        dc.b $01 ;          ; .......#####....................................
                        dc.b $80 ; #....... ; ........######..##..............................
                        dc.b $03 ;          ; .........########..........###..................
                        dc.b $01 ; .......# ; ..........#######.........####..................
                        dc.b $04 ;          ; ...........########......####...................
                        dc.b $e0 ; ###..... ; ............#########..#####....................
                        dc.b $06 ;          ; ...........##.#############.....................
                        dc.b $01 ; .......# ; ................###########.....................
                        dc.b $07 ;          ; ..................########......................
                        dc.b $f0 ; ####.... ; ...............##..#########....................
                        dc.b $0a ;          ; ..................###########..##...............
                        dc.b $fc ; ######.. ; .................####.##########................
                        dc.b $0b ;          ; .................###....#########...............
                        dc.b $c0 ; ##...... ; .....................##..#########..............
                        dc.b $0d ;          ; ..........................#########.............
                        dc.b $7f ; .####### ; .........................##..########...........
                        dc.b $0e ;          ; ...............................#######..........
                        dc.b $80 ; #....... ; ..................................#####.........
                        dc.b $10 ; 
                        dc.b $3f ; ..######
                        dc.b $11 ; 
                        dc.b $80 ; #.......
                        dc.b $13 ; 
                        dc.b $1f ; ...#####
                        dc.b $14 ; 
                        dc.b $e0 ; ###.....
                        dc.b $16 ; 
                        dc.b $0f ; ....####
                        dc.b $17 ; 
                        dc.b $f9 ; #####..#
                        dc.b $19 ; 
                        dc.b $1b ; ...##.##
                        dc.b $1a ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $3f ; ..######
                        dc.b $22 ; 
                        dc.b $01 ; .......#
                        dc.b $23 ; 
                        dc.b $9f ; #..#####
                        dc.b $26 ; 
                        dc.b $3f ; ..######
                        dc.b $29 ; 
                        dc.b $7b ; .####.##
                        dc.b $2c ; 
                        dc.b $70 ; .###....
                        dc.b $2f ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_22         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0c ; 
                        dc.b $1c ; ...###..
                        dc.b $0f ; 
                        dc.b $3c ; ..####..
                        dc.b $12 ; 
                        dc.b $78 ; .####...
                        dc.b $15 ; 
                        dc.b $f0 ; ####....
                        dc.b $18 ; 
                        dc.b $e0 ; ###.....
                        dc.b $1b ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $c0 ; ##......
                        dc.b $21 ; 
                        dc.b $f0 ; ####....
                        dc.b $24 ; 
                        dc.b $f9 ; #####..#
                        dc.b $25 ; 
                        dc.b $80 ; #.......
                        dc.b $27 ; 
                        dc.b $ff ; ########
                        dc.b $2a ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $80 ; #.......
                        dc.b $2d ; 
                        dc.b $7f ; .#######
                        dc.b $2e ; 
                        dc.b $c0 ; ##......
                        dc.b $30 ; 
                        dc.b $3f ; ..######
                        dc.b $31 ; 
                        dc.b $e0 ; ###.....
                        dc.b $33 ; 
                        dc.b $67 ; .##..###
                        dc.b $34 ; 
                        dc.b $f8 ; #####...
                        dc.b $36 ; 
                        dc.b $01 ; .......#
                        dc.b $37 ; 
                        dc.b $fc ; ######..
                        dc.b $3a ; 
                        dc.b $3e ; ..#####.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_00          equ  *
SP_Dat_Hill_00          equ  *
SP_Dat_Plane_23         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $04 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ........................
                        dc.b $0a ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ........................
                        dc.b $10 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ........................
                        dc.b $1e ;          ; ........................
                        dc.b $cc ; ##..##.. ; ........................
                        dc.b $1f ;          ; ........................
                        dc.b $18 ; ...##... ; ##..##.....##.....##..##
                        dc.b $20 ;          ; ........................
                        dc.b $33 ; ..##..## ; ........................
                        dc.b $2e ;          ; ........................
                        dc.b $18 ; ...##... ; ........................
                        dc.b $34 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ........................
                        dc.b $3a ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ........................
                                 ;          ; ...........##...........
                                            
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_01          equ  *
SP_Dat_Plane_24         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $00 ;          ; ..##................##..
                        dc.b $30 ; ..##.... ; .####..............####.
                        dc.b $02 ;          ; ######............######
                        dc.b $0c ; ....##.. ; ######............######
                        dc.b $03 ;          ; ######............######
                        dc.b $78 ; .####... ; ######............######
                        dc.b $05 ;          ; .####..............####.
                        dc.b $1e ; ...####.
                        dc.b $06 ; 
                        dc.b $fc ; ######..
                        dc.b $08 ; 
                        dc.b $3f ; ..######
                        dc.b $09 ; 
                        dc.b $fc ; ######..
                        dc.b $0b ; 
                        dc.b $3f ; ..######
                        dc.b $0c ; 
                        dc.b $fc ; ######..
                        dc.b $0e ; 
                        dc.b $3f ; ..######
                        dc.b $0f ; 
                        dc.b $fc ; ######..
                        dc.b $11 ; 
                        dc.b $3f ; ..######
                        dc.b $12 ; 
                        dc.b $78 ; .####...
                        dc.b $14 ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_02          equ  *
SP_Dat_Plane_25         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $00 ;          ; ...##..............##...
                        dc.b $18 ; ...##... ; ..####............####..
                        dc.b $02 ;          ; .######..........######.
                        dc.b $18 ; ...##... ; .######..........######.
                        dc.b $03 ;          ; .######..........######.
                        dc.b $3c ; ..####.. ; .######..........######.
                        dc.b $05 ;          ; ..####............####..
                        dc.b $3c ; ..####..
                        dc.b $06 ; 
                        dc.b $7e ; .######.
                        dc.b $08 ; 
                        dc.b $7e ; .######.
                        dc.b $09 ; 
                        dc.b $7e ; .######.
                        dc.b $0b ; 
                        dc.b $7e ; .######.
                        dc.b $0c ; 
                        dc.b $7e ; .######.
                        dc.b $0e ; 
                        dc.b $7e ; .######.
                        dc.b $0f ; 
                        dc.b $7e ; .######.
                        dc.b $11 ; 
                        dc.b $7e ; .######.
                        dc.b $12 ; 
                        dc.b $3c ; ..####..
                        dc.b $14 ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_03          equ  *
SP_Dat_Plane_26         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $00 ;          ; ...###............###...
                        dc.b $1c ; ...###.. ; ..#####..........#####..
                        dc.b $02 ;          ; ..#####..........#####..
                        dc.b $38 ; ..###... ; ..#####..........#####..
                        dc.b $03 ;          ; ..#####..........#####..
                        dc.b $3e ; ..#####. ; ...###............###...
                        dc.b $05 ; 
                        dc.b $7c ; .#####..
                        dc.b $06 ; 
                        dc.b $3e ; ..#####.
                        dc.b $08 ; 
                        dc.b $7c ; .#####..
                        dc.b $09 ; 
                        dc.b $3e ; ..#####.
                        dc.b $0b ; 
                        dc.b $7c ; .#####..
                        dc.b $0c ; 
                        dc.b $3e ; ..#####.
                        dc.b $0e ; 
                        dc.b $7c ; .#####..
                        dc.b $0f ; 
                        dc.b $1c ; ...###..
                        dc.b $11 ; 
                        dc.b $38 ; ..###...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_04          equ  *
SP_Dat_Plane_27         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $00 ;          ; ....###..........###....
                        dc.b $0e ; ....###. ; ...#####........#####...
                        dc.b $02 ;          ; ...#####........#####...
                        dc.b $70 ; .###.... ; ...#####........#####...
                        dc.b $03 ;          ; ....###..........###....
                        dc.b $1f ; ...#####
                        dc.b $05 ; 
                        dc.b $f8 ; #####...
                        dc.b $06 ; 
                        dc.b $1f ; ...#####
                        dc.b $08 ; 
                        dc.b $f8 ; #####...
                        dc.b $09 ; 
                        dc.b $1f ; ...#####
                        dc.b $0b ; 
                        dc.b $f8 ; #####...
                        dc.b $0c ; 
                        dc.b $0e ; ....###.
                        dc.b $0e ; 
                        dc.b $70 ; .###....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_05          equ  *
SP_Dat_Plane_28         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $00 ;          ; .....###........###.....
                        dc.b $07 ; .....### ; ....#####......#####....
                        dc.b $02 ;          ; ....#####......#####....
                        dc.b $e0 ; ###..... ; .....###........###.....
                        dc.b $03 ; 
                        dc.b $0f ; ....####
                        dc.b $04 ; 
                        dc.b $81 ; #......#
                        dc.b $05 ; 
                        dc.b $f0 ; ####....
                        dc.b $06 ; 
                        dc.b $0f ; ....####
                        dc.b $07 ; 
                        dc.b $81 ; #......#
                        dc.b $08 ; 
                        dc.b $f0 ; ####....
                        dc.b $09 ; 
                        dc.b $07 ; .....###
                        dc.b $0b ; 
                        dc.b $e0 ; ###.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_06          equ  *
SP_Dat_Plane_29         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $00 ;          ; ......##........##......
                        dc.b $03 ; ......## ; .....####......####.....
                        dc.b $02 ;          ; .....####......####.....
                        dc.b $c0 ; ##...... ; ......##........##......
                        dc.b $03 ; 
                        dc.b $07 ; .....###
                        dc.b $04 ; 
                        dc.b $81 ; #......#
                        dc.b $05 ; 
                        dc.b $e0 ; ###.....
                        dc.b $06 ; 
                        dc.b $07 ; .....###
                        dc.b $07 ; 
                        dc.b $81 ; #......#
                        dc.b $08 ; 
                        dc.b $e0 ; ###.....
                        dc.b $09 ; 
                        dc.b $03 ; ......##
                        dc.b $0b ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_07          equ  *
SP_Dat_Plane_2a         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $00 ;          ; ......###......###......
                        dc.b $03 ; ......## ; ......###......###......
                        dc.b $01 ;          ; ......###......###......
                        dc.b $81 ; #......#
                        dc.b $02 ; 
                        dc.b $c0 ; ##......
                        dc.b $03 ; 
                        dc.b $03 ; ......##
                        dc.b $04 ; 
                        dc.b $81 ; #......#
                        dc.b $05 ; 
                        dc.b $c0 ; ##......
                        dc.b $06 ; 
                        dc.b $03 ; ......##
                        dc.b $07 ; 
                        dc.b $81 ; #......#
                        dc.b $08 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_08          equ  *
SP_Dat_Plane_2b         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $00 ;          ; .......###....###.......
                        dc.b $01 ; .......# ; .......###....###.......
                        dc.b $01 ; 
                        dc.b $c3 ; ##....##
                        dc.b $02 ; 
                        dc.b $80 ; #.......
                        dc.b $03 ; 
                        dc.b $01 ; .......#
                        dc.b $04 ; 
                        dc.b $c3 ; ##....##
                        dc.b $05 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_09          equ  *
SP_Dat_Plane_2c         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $01 ;          ; ........##....##........
                        dc.b $c3 ; ##....## ; ........##....##........
                        dc.b $04 ; 
                        dc.b $c3 ; ##....##
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_0a          equ  *
SP_Dat_Plane_2d         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $01 ;          ; .........##..##.........
                        dc.b $66 ; .##..##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_0b          equ  *
SP_Dat_Plane_2e         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $01 ;          ; ..........####..........
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_0c          equ  *
SP_Dat_Plane_2f         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $01 ;          ; ...........##...........
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_0d          equ  *
SP_Dat_Plane_30         dc.b $00 ; <flag: full sprite data>
                                                
                        dc.b $78, $00, $1e  ; .####..............####.
                        dc.b $fc, $00, $3f  ; ######............######
                        dc.b $fc, $00, $3f  ; ######............######
                        dc.b $fc, $00, $3f  ; ######............######
                        dc.b $fc, $00, $3f  ; ######............######
                        dc.b $fc, $00, $3f  ; ######............######
                        dc.b $fc, $00, $3f  ; ######............######
                        dc.b $fc, $00, $3f  ; ######............######
                        dc.b $fc, $00, $3f  ; ######............######
                        dc.b $b4, $00, $2d  ; #.##.#............#.##.#
                        dc.b $78, $00, $1e  ; .####..............####.
                        dc.b $78, $00, $1e  ; .####..............####.
                        dc.b $78, $00, $1e  ; .####..............####.
                        dc.b $78, $00, $1e  ; .####..............####.
                        dc.b $78, $00, $1e  ; .####..............####.
                        dc.b $78, $00, $1e  ; .####..............####.
                        dc.b $78, $00, $1e  ; .####..............####.
                        dc.b $78, $00, $1e  ; .####..............####.
                        dc.b $78, $00, $1e  ; .####..............####.
                        dc.b $78, $00, $1e  ; .####..............####.
                        dc.b $78, $00, $1e  ; .####..............####.
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_0e          equ  *
SP_Dat_Plane_31         dc.b $00 ; <flag: full sprite data>
                                                
                        dc.b $00, $00, $00 ; ........................
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $b4, $00, $2d ; #.##.#............#.##.#
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_0f          equ  *
SP_Dat_Plane_32         dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $b4, $00, $2d ; #.##.#............#.##.#
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_10          equ  *
SP_Dat_Plane_33         dc.b $00 ; <flag: full sprite data>
                                                
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $b4, $00, $2d ; #.##.#............#.##.#
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_11          equ  *
SP_Dat_Plane_34         dc.b $00 ; <flag: full sprite data>
                                                
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $b4, $00, $2d ; #.##.#............#.##.#
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_12          equ  *
SP_Dat_Plane_35         dc.b $00 ; <flag: full sprite data>
                                                
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $fc, $00, $3f ; ######............######
                        dc.b $b4, $00, $2d ; #.##.#............#.##.#
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
                        dc.b $78, $00, $1e ; .####..............####.
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_13          equ  *
SP_Dat_Plane_36         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $12 ;          ; ........................
                        dc.b $78 ; .####... ; ........................
                        dc.b $14 ;          ; ........................
                        dc.b $1e ; ...####. ; ........................
                        dc.b $15 ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $17 ;          ; .####..............####.
                        dc.b $3f ; ..###### ; ######............######
                        dc.b $18 ;          ; ######............######
                        dc.b $fc ; ######.. ; ######............######
                        dc.b $1a ;          ; ######............######
                        dc.b $3f ; ..###### ; ######............######
                        dc.b $1b ;          ; #.##.#............#.##.#
                        dc.b $fc ; ######.. ; .####..............####.
                        dc.b $1d ;          ; .####..............####.
                        dc.b $3f ; ..###### ; .####..............####.
                        dc.b $1e ;          ; .####..............####.
                        dc.b $fc ; ######.. ; .####..............####.
                        dc.b $20 ;          ; .####..............####.
                        dc.b $3f ; ..###### ; .####..............####.
                        dc.b $21 ;          ; .####..............####.
                        dc.b $fc ; ######..
                        dc.b $23 ; 
                        dc.b $3f ; ..######
                        dc.b $24 ; 
                        dc.b $b4 ; #.##.#..
                        dc.b $26 ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $27 ; 
                        dc.b $78 ; .####...
                        dc.b $29 ; 
                        dc.b $1e ; ...####.
                        dc.b $2a ; 
                        dc.b $78 ; .####...
                        dc.b $2c ; 
                        dc.b $1e ; ...####.
                        dc.b $2d ; 
                        dc.b $78 ; .####...
                        dc.b $2f ; 
                        dc.b $1e ; ...####.
                        dc.b $30 ; 
                        dc.b $78 ; .####...
                        dc.b $32 ; 
                        dc.b $1e ; ...####.
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_14          equ  *
SP_Dat_Plane_37         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $15 ;          ; ........................
                        dc.b $78 ; .####... ; ........................
                        dc.b $17 ;          ; ........................
                        dc.b $1e ; ...####. ; ........................
                        dc.b $18 ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $1a ;          ; ........................
                        dc.b $3f ; ..###### ; .####..............####.
                        dc.b $1b ;          ; ######............######
                        dc.b $fc ; ######.. ; ######............######
                        dc.b $1d ;          ; ######............######
                        dc.b $3f ; ..###### ; ######............######
                        dc.b $1e ;          ; ######............######
                        dc.b $fc ; ######.. ; #.##.#............#.##.#
                        dc.b $20 ;          ; .####..............####.
                        dc.b $3f ; ..###### ; .####..............####.
                        dc.b $21 ;          ; .####..............####.
                        dc.b $fc ; ######.. ; .####..............####.
                        dc.b $23 ;          ; .####..............####.
                        dc.b $3f ; ..###### ; .####..............####.
                        dc.b $24 ;          ; .####..............####.
                        dc.b $fc ; ######..
                        dc.b $26 ; 
                        dc.b $3f ; ..######
                        dc.b $27 ; 
                        dc.b $b4 ; #.##.#..
                        dc.b $29 ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $2a ; 
                        dc.b $78 ; .####...
                        dc.b $2c ; 
                        dc.b $1e ; ...####.
                        dc.b $2d ; 
                        dc.b $78 ; .####...
                        dc.b $2f ; 
                        dc.b $1e ; ...####.
                        dc.b $30 ; 
                        dc.b $78 ; .####...
                        dc.b $32 ; 
                        dc.b $1e ; ...####.
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_15          equ  *
SP_Dat_Plane_38         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $18 ;          ; ........................
                        dc.b $78 ; .####... ; ........................
                        dc.b $1a ;          ; ........................
                        dc.b $1e ; ...####. ; ........................
                        dc.b $1b ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $1d ;          ; ........................
                        dc.b $3f ; ..###### ; ........................
                        dc.b $1e ;          ; .####..............####.
                        dc.b $fc ; ######.. ; ######............######
                        dc.b $20 ;          ; ######............######
                        dc.b $3f ; ..###### ; ######............######
                        dc.b $21 ;          ; ######............######
                        dc.b $fc ; ######.. ; #.##.#............#.##.#
                        dc.b $23 ;          ; .####..............####.
                        dc.b $3f ; ..###### ; .####..............####.
                        dc.b $24 ;          ; .####..............####.
                        dc.b $fc ; ######.. ; .####..............####.
                        dc.b $26 ;          ; .####..............####.
                        dc.b $3f ; ..###### ; .####..............####.
                        dc.b $27 ;          ; .####..............####.
                        dc.b $b4 ; #.##.#..
                        dc.b $29 ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $2a ; 
                        dc.b $78 ; .####...
                        dc.b $2c ; 
                        dc.b $1e ; ...####.
                        dc.b $2d ; 
                        dc.b $78 ; .####...
                        dc.b $2f ; 
                        dc.b $1e ; ...####.
                        dc.b $30 ; 
                        dc.b $78 ; .####...
                        dc.b $32 ; 
                        dc.b $1e ; ...####.
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_16          equ  *
SP_Dat_Plane_39         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $1b ;          ; ........................
                        dc.b $78 ; .####... ; ........................
                        dc.b $1d ;          ; ........................
                        dc.b $1e ; ...####. ; ........................
                        dc.b $1e ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $20 ;          ; ........................
                        dc.b $3f ; ..###### ; ........................
                        dc.b $21 ;          ; ........................
                        dc.b $fc ; ######.. ; .####..............####.
                        dc.b $23 ;          ; ######............######
                        dc.b $3f ; ..###### ; ######............######
                        dc.b $24 ;          ; ######............######
                        dc.b $fc ; ######.. ; ######............######
                        dc.b $26 ;          ; #.##.#............#.##.#
                        dc.b $3f ; ..###### ; .####..............####.
                        dc.b $27 ;          ; .####..............####.
                        dc.b $fc ; ######.. ; .####..............####.
                        dc.b $29 ;          ; .####..............####.
                        dc.b $3f ; ..###### ; .####..............####.
                        dc.b $2a ;          ; .####..............####.
                        dc.b $b4 ; #.##.#..
                        dc.b $2c ; 
                        dc.b $2d ; ..#.##.#
                        dc.b $2d ; 
                        dc.b $78 ; .####...
                        dc.b $2f ; 
                        dc.b $1e ; ...####.
                        dc.b $30 ; 
                        dc.b $78 ; .####...
                        dc.b $32 ; 
                        dc.b $1e ; ...####.
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_17          equ  *
SP_Dat_Plane_3a         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $1e ;          ; ........................
                        dc.b $78 ; .####... ; ........................
                        dc.b $20 ;          ; ........................
                        dc.b $1e ; ...####. ; ........................
                        dc.b $21 ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $23 ;          ; ........................
                        dc.b $3f ; ..###### ; ........................
                        dc.b $24 ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $26 ;          ; .####..............####.
                        dc.b $3f ; ..###### ; ######............######
                        dc.b $27 ;          ; ######............######
                        dc.b $fc ; ######.. ; ######............######
                        dc.b $29 ;          ; #.##.#............#.##.#
                        dc.b $3f ; ..###### ; .####..............####.
                        dc.b $2a ;          ; .####..............####.
                        dc.b $b4 ; #.##.#.. ; .####..............####.
                        dc.b $2c ;          ; .####..............####.
                        dc.b $2d ; ..#.##.# ; .####..............####.
                        dc.b $2d ;          ; .####..............####.
                        dc.b $78 ; .####...
                        dc.b $2f ; 
                        dc.b $1e ; ...####.
                        dc.b $30 ; 
                        dc.b $78 ; .####...
                        dc.b $32 ; 
                        dc.b $1e ; ...####.
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_18          equ  *
SP_Dat_Plane_3b         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $21 ;          ; ........................
                        dc.b $78 ; .####... ; ........................
                        dc.b $23 ;          ; ........................
                        dc.b $1e ; ...####. ; ........................
                        dc.b $24 ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $26 ;          ; ........................
                        dc.b $3f ; ..###### ; ........................
                        dc.b $27 ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $29 ;          ; ........................
                        dc.b $3f ; ..###### ; .####..............####.
                        dc.b $2a ;          ; ######............######
                        dc.b $fc ; ######.. ; ######............######
                        dc.b $2c ;          ; ######............######
                        dc.b $3f ; ..###### ; #.##.#............#.##.#
                        dc.b $2d ;          ; .####..............####.
                        dc.b $b4 ; #.##.#.. ; .####..............####.
                        dc.b $2f ;          ; .####..............####.
                        dc.b $2d ; ..#.##.# ; .####..............####.
                        dc.b $30 ;          ; .####..............####.
                        dc.b $78 ; .####...
                        dc.b $32 ; 
                        dc.b $1e ; ...####.
                        dc.b $33 ; 
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_19          equ  *
SP_Dat_Plane_3c         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $24 ;          ; ........................
                        dc.b $78 ; .####... ; ........................
                        dc.b $26 ;          ; ........................
                        dc.b $1e ; ...####. ; ........................
                        dc.b $27 ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $29 ;          ; ........................
                        dc.b $3f ; ..###### ; ........................
                        dc.b $2a ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $2c ;          ; ........................
                        dc.b $3f ; ..###### ; ........................
                        dc.b $2d ;          ; .####..............####.
                        dc.b $b4 ; #.##.#.. ; ######............######
                        dc.b $2f ;          ; ######............######
                        dc.b $2d ; ..#.##.# ; #.##.#............#.##.#
                        dc.b $30 ;          ; .####..............####.
                        dc.b $78 ; .####... ; .####..............####.
                        dc.b $32 ;          ; .####..............####.
                        dc.b $1e ; ...####. ; .####..............####.
                        dc.b $33 ;          ; .####..............####.
                        dc.b $78 ; .####...
                        dc.b $35 ; 
                        dc.b $1e ; ...####.
                        dc.b $36 ; 
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_1a          equ  *
SP_Dat_Plane_3d         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $27 ;          ; ........................
                        dc.b $78 ; .####... ; ........................
                        dc.b $29 ;          ; ........................
                        dc.b $1e ; ...####. ; ........................
                        dc.b $2a ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $2c ;          ; ........................
                        dc.b $3f ; ..###### ; ........................
                        dc.b $2d ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $2f ;          ; ........................
                        dc.b $3f ; ..###### ; ........................
                        dc.b $30 ;          ; ........................
                        dc.b $b4 ; #.##.#.. ; .####..............####.
                        dc.b $32 ;          ; ######............######
                        dc.b $2d ; ..#.##.# ; ######............######
                        dc.b $33 ;          ; #.##.#............#.##.#
                        dc.b $78 ; .####... ; .####..............####.
                        dc.b $35 ;          ; .####..............####.
                        dc.b $1e ; ...####. ; .####..............####.
                        dc.b $36 ;          ; .####..............####.
                        dc.b $78 ; .####...
                        dc.b $38 ; 
                        dc.b $1e ; ...####.
                        dc.b $39 ; 
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_1b          equ  *
SP_Dat_Plane_3e         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $2a ;          ; ........................
                        dc.b $78 ; .####... ; ........................
                        dc.b $2c ;          ; ........................
                        dc.b $1e ; ...####. ; ........................
                        dc.b $2d ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $2f ;          ; ........................
                        dc.b $3f ; ..###### ; ........................
                        dc.b $30 ;          ; ........................
                        dc.b $b4 ; #.##.#.. ; ........................
                        dc.b $32 ;          ; ........................
                        dc.b $2d ; ..#.##.# ; ........................
                        dc.b $33 ;          ; ........................
                        dc.b $78 ; .####... ; ........................
                        dc.b $35 ;          ; .####..............####.
                        dc.b $1e ; ...####. ; ######............######
                        dc.b $36 ;          ; #.##.#............#.##.#
                        dc.b $78 ; .####... ; .####..............####.
                        dc.b $38 ;          ; .####..............####.
                        dc.b $1e ; ...####. ; .####..............####.
                        dc.b $39 ;          ; .####..............####.
                        dc.b $78 ; .####...
                        dc.b $3b ; 
                        dc.b $1e ; ...####.
                        dc.b $3c ; 
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_1c          equ  *
SP_Dat_Plane_3f         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $2d ;          ; ........................
                        dc.b $78 ; .####... ; ........................
                        dc.b $2f ;          ; ........................
                        dc.b $1e ; ...####. ; ........................
                        dc.b $30 ;          ; ........................
                        dc.b $fc ; ######.. ; ........................
                        dc.b $32 ;          ; ........................
                        dc.b $3f ; ..###### ; ........................
                        dc.b $33 ;          ; ........................
                        dc.b $b4 ; #.##.#.. ; ........................
                        dc.b $35 ;          ; ........................
                        dc.b $2d ; ..#.##.# ; ........................
                        dc.b $36 ;          ; ........................
                        dc.b $78 ; .####... ; ........................
                        dc.b $38 ;          ; ........................
                        dc.b $1e ; ...####. ; .####..............####.
                        dc.b $39 ;          ; ######............######
                        dc.b $78 ; .####... ; #.##.#............#.##.#
                        dc.b $3b ;          ; .####..............####.
                        dc.b $1e ; ...####. ; .####..............####.
                        dc.b $3c ;          ; .####..............####.
                        dc.b $78 ; .####...
                        dc.b $3e ; 
                        dc.b $1e ; ...####.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_1d          equ  *
SP_Dat_Hill_4e          equ  *
SP_Dat_Plane_40         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $1f ; 
                        dc.b $18 ; ...##... ; ...........##...........
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_1e          equ  *
SP_Dat_Hill_4f          equ  *
SP_Dat_Plane_41         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $1f ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ...........##...........
                        dc.b $22 ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_1f          equ  *
SP_Dat_Hill_50          equ  *
SP_Dat_Plane_42         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $1f ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ..........####..........
                        dc.b $22 ;          ; ...........##...........
                        dc.b $3c ; ..####..
                        dc.b $25 ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_20          equ  *
SP_Dat_Hill_51          equ  *
SP_Dat_Plane_43         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $22 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ..........####..........
                        dc.b $25 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; ...........##...........
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        dc.b $2b ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_21          equ  *
SP_Dat_Hill_52          equ  *
SP_Dat_Plane_44         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $22 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ..........####..........
                        dc.b $25 ;          ; .........######.........
                        dc.b $3c ; ..####.. ; ..........####..........
                        dc.b $28 ;          ; ...........##...........
                        dc.b $7e ; .######.
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_22          equ  *
SP_Dat_Hill_53          equ  *
SP_Dat_Plane_45         dc.b $40 ; <flag: partial sprite data>
                                                
                        dc.b $25 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ..........####..........
                        dc.b $28 ;          ; .........######.........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $2b ;          ; ..........####..........
                        dc.b $7e ; .######. ; ...........##...........
                        dc.b $2e ; 
                        dc.b $7e ; .######.
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_54          equ  *
SP_Dat_Plane_46         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $28 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ..........####..........
                        dc.b $2b ;          ; .........######.........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $2e ;          ; .........######.........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $31 ;          ; ...........##...........
                        dc.b $7e ; .######.
                        dc.b $34 ; 
                        dc.b $7e ; .######.
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_55          equ  *
SP_Dat_Plane_47         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $28 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ..........####..........
                        dc.b $2b ;          ; .........######.........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $2e ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $31 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ...........##...........
                        dc.b $34 ; 
                        dc.b $7e ; .######.
                        dc.b $37 ; 
                        dc.b $7e ; .######.
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_48         dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $08, $08, $00 ; ....#.......#...........
                        dc.b $06, $36, $00 ; .....##...##.##.........
                        dc.b $03, $6b, $40 ; ......##.##.#.##.#......
                        dc.b $0a, $ed, $b0 ; ....#.#.###.##.##.##....
                        dc.b $1a, $aa, $98 ; ...##.#.#.#.#.#.#..##...
                        dc.b $0d, $9a, $60 ; ....##.##..##.#..##.....
                        dc.b $3a, $eb, $80 ; ..###.#.###.#.###.......
                        dc.b $aa, $a6, $90 ; #.#.#.#.#.#..##.#..#....
                        dc.b $76, $6e, $b4 ; .###.##..##.###.#.##.#..
                        dc.b $2b, $aa, $68 ; ..#.#.###.#.#.#..##.#...
                        dc.b $06, $96, $ae ; .....##.#..#.##.#.#.###.
                        dc.b $03, $ae, $99 ; ......###.#.###.#..##..#
                        dc.b $09, $a9, $b8 ; ....#..##.#.#..##.###...
                        dc.b $03, $4a, $a4 ; ......##.#..#.#.#.#..#..
                        dc.b $00, $01, $e0 ; ...............####.....
                        dc.b $00, $00, $90 ; ................#..#....
                        dc.b $00, $00, $80 ; ................#.......
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_49         dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $90, $00 ; ........#..#................##..................
                        dc.b $00, $22, $02 ; ..........#...#.......#.#..##.......#...........
                        dc.b $00, $e9, $c1 ; ........###.#..###.....####.......##.##.........
                        dc.b $00, $00, $93 ; ................#..#..##.##........#............
                        dc.b $00, $28, $76 ; ..........#.#....###.##.#.##..###.#......###....
                        dc.b $08, $36, $ae ; ....#.....##.##.#.#.###.#..##.#.#.#...#.#.......
                        dc.b $06, $0b, $a9 ; .....##.....#.###.#.#..####.###..##...#.##......
                        dc.b $3a, $86, $9a ; ..###.#.#....##.#..##.#.#.#.#.#.#.#.##.##.......
                        dc.b $01, $a9, $ae ; .......##.#.#..##.#.###.#.#..##.###.#.#.#...#.#.
                        dc.b $22, $ba, $69 ; ..#...#.#.###.#..##.#..#.####.#.#..##.#.###.##..
                        dc.b $9a, $66, $b6 ; #..##.#..##..##.#.##.##.#.#.#..##.#.#.##.##..#..
                        dc.b $27, $aa, $aa ; ..#..####.#.#.#.#.#.#.#.#..##.###.#..##.#.#.#..#
                        dc.b $08, $0b, $9b ; ....#.......#.###..##.#####.#.#..####.#.#..####.
                        dc.b $00, $89, $a9 ; ........#...#..##.#.#..##.#.#.#.#.#.#.....#.#...
                        dc.b $00, $26, $ba ; ..........#..##.#.###.#.#....##.#..##........#..
                        dc.b $00, $aa, $6a ; ........#.#.#.#..##.#.#..#..###.#.#.###.........
                        dc.b $00, $9e, $a7 ; ........#..####.#.#..####......#..###.#.#.......
                        dc.b $00, $c1, $3a ; ........##.....#..###.#.#..#..#.#....##.##......
                        dc.b $02, $48, $19 ; ......#..#..#......##..##.##..###......##.......
                        dc.b $03, $04, $08 ; ......##.....#......#...###...#..##.....#.......
                        dc.b $00, $00, $00 ; ...............................#................
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_4a         dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $0c, $00, $00 ; ....##..................
                        dc.b $98, $08, $00 ; #..##.......#...........
                        dc.b $e0, $36, $00 ; ###.......##.##.........
                        dc.b $60, $10, $00 ; .##........#............
                        dc.b $b3, $a0, $70 ; #.##..###.#......###....
                        dc.b $9a, $a2, $80 ; #..##.#.#.#...#.#.......
                        dc.b $ee, $62, $c0 ; ###.###..##...#.##......
                        dc.b $aa, $ad, $80 ; #.#.#.#.#.#.##.##.......
                        dc.b $a6, $ea, $8a ; #.#..##.###.#.#.#...#.#.
                        dc.b $7a, $9a, $ec ; .####.#.#..##.#.###.##..
                        dc.b $a9, $ab, $64 ; #.#.#..##.#.#.##.##..#..
                        dc.b $9b, $a6, $a9 ; #..##.###.#..##.#.#.#..#
                        dc.b $ea, $7a, $9e ; ###.#.#..####.#.#..####.
                        dc.b $aa, $a8, $28 ; #.#.#.#.#.#.#.....#.#...
                        dc.b $86, $98, $04 ; #....##.#..##........#..
                        dc.b $4e, $ae, $00 ; .#..###.#.#.###.........
                        dc.b $81, $3a, $80 ; #......#..###.#.#.......
                        dc.b $92, $86, $c0 ; #..#..#.#....##.##......
                        dc.b $b3, $81, $80 ; #.##..###......##.......
                        dc.b $e2, $60, $80 ; ###...#..##.....#.......
                        dc.b $01, $00, $00 ; .......#................
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_4b         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1a ;           .....................##.
                        dc.b $06 ; .....##.  .........######.....###.
                        dc.b $1c ;           ..######################
                        dc.b $7e ; .######.  ####################....
                        dc.b $1d ;           ..#############.........
                        dc.b $0e ; ....###.
                        dc.b $1e ; 
                        dc.b $3f ; ..######
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $ff ; ########
                        dc.b $21 ; 
                        dc.b $ff ; ########
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $f0 ; ####....
                        dc.b $24 ; 
                        dc.b $3f ; ..######
                        dc.b $25 ; 
                        dc.b $fe ; #######.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Plane_4c         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ;           .##.....................
                        dc.b $60 ; .##.....  .###.....######.........
                        dc.b $1b ;           ######################..
                        dc.b $70 ; .###....  ....####################
                        dc.b $1c ;           .........#############..
                        dc.b $7e ; .######.
                        dc.b $1e ; 
                        dc.b $ff ; ########
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $fc ; ######..
                        dc.b $21 ; 
                        dc.b $0f ; ....####
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $ff ; ########
                        dc.b $25 ; 
                        dc.b $7f ; .#######
                        dc.b $26 ; 
                        dc.b $fc ; ######..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Cave_00          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ;          ; ..........###...........
                        dc.b $38 ; ..###... ; ..........###...........
                        dc.b $16 ;          ; ..........###...........
                        dc.b $38 ; ..###... ; ..........###...........
                        dc.b $19 ;          ; ..........###...........
                        dc.b $38 ; ..###... ; ..........###...........
                        dc.b $1c ;          ; ..........###...........
                        dc.b $38 ; ..###... ; ..........###...........
                        dc.b $1f ; 
                        dc.b $38 ; ..###...
                        dc.b $22 ; 
                        dc.b $38 ; ..###...
                        dc.b $25 ; 
                        dc.b $38 ; ..###...
                        dc.b $28 ; 
                        dc.b $38 ; ..###...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Cave_01          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ;          ; ............###.........
                        dc.b $0e ; ....###. ; ............###.........
                        dc.b $16 ;          ; ...........###..........
                        dc.b $0e ; ....###. ; ...........###..........
                        dc.b $19 ;          ; ..........###...........
                        dc.b $1c ; ...###.. ; ..........###...........
                        dc.b $1c ;          ; .........###............
                        dc.b $1c ; ...###.. ; .........###............
                        dc.b $1f ; 
                        dc.b $38 ; ..###...
                        dc.b $22 ; 
                        dc.b $38 ; ..###...
                        dc.b $25 ; 
                        dc.b $70 ; .###....
                        dc.b $28 ; 
                        dc.b $70 ; .###....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Cave_02          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ;          ; ..............##........
                        dc.b $03 ; ......## ; .............###........
                        dc.b $16 ;          ; ............###.........
                        dc.b $07 ; .....### ; ...........###..........
                        dc.b $19 ;          ; ..........###...........
                        dc.b $0e ; ....###. ; .........###............
                        dc.b $1c ;          ; ........###.............
                        dc.b $1c ; ...###.. ; ........##..............
                        dc.b $1f ; 
                        dc.b $38 ; ..###...
                        dc.b $22 ; 
                        dc.b $70 ; .###....
                        dc.b $25 ; 
                        dc.b $e0 ; ###.....
                        dc.b $28 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Cave_03          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $16 ;          ; ...............###......
                        dc.b $01 ; .......# ; .............#####......
                        dc.b $17 ;          ; ...........#####........
                        dc.b $c0 ; ##...... ; .........#####..........
                        dc.b $19 ;          ; .......#####............
                        dc.b $07 ; .....### ; .......###..............
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1c ; 
                        dc.b $1f ; ...#####
                        dc.b $1f ; 
                        dc.b $7c ; .#####..
                        dc.b $21 ; 
                        dc.b $01 ; .......#
                        dc.b $22 ; 
                        dc.b $f0 ; ####....
                        dc.b $24 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Cave_04          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1b ;          ; ......############......
                        dc.b $03 ; ......## ; ......############......
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $c0 ; ##......
                        dc.b $1e ; 
                        dc.b $03 ; ......##
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Cave_05          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ;          ; .......###..............
                        dc.b $01 ; .......# ; .......#####............
                        dc.b $16 ;          ; .........#####..........
                        dc.b $c0 ; ##...... ; ...........#####........
                        dc.b $18 ;          ; .............#####......
                        dc.b $01 ; .......# ; ...............###......
                        dc.b $19 ; 
                        dc.b $f0 ; ####....
                        dc.b $1c ; 
                        dc.b $7c ; .#####..
                        dc.b $1f ; 
                        dc.b $1f ; ...#####
                        dc.b $22 ; 
                        dc.b $07 ; .....###
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $01 ; .......#
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Cave_06          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ;          ; ........##..............
                        dc.b $c0 ; ##...... ; ........###.............
                        dc.b $16 ;          ; .........###............
                        dc.b $e0 ; ###..... ; ..........###...........
                        dc.b $19 ;          ; ...........###..........
                        dc.b $70 ; .###.... ; ............###.........
                        dc.b $1c ;          ; .............###........
                        dc.b $38 ; ..###... ; ..............##........
                        dc.b $1f ; 
                        dc.b $1c ; ...###..
                        dc.b $22 ; 
                        dc.b $0e ; ....###.
                        dc.b $25 ; 
                        dc.b $07 ; .....###
                        dc.b $28 ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Cave_07          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ;          ; .........###............
                        dc.b $70 ; .###.... ; .........###............
                        dc.b $16 ;          ; ..........###...........
                        dc.b $70 ; .###.... ; ..........###...........
                        dc.b $19 ;          ; ...........###..........
                        dc.b $38 ; ..###... ; ...........###..........
                        dc.b $1c ;          ; ............###.........
                        dc.b $38 ; ..###... ; ............###.........
                        dc.b $1f ; 
                        dc.b $1c ; ...###..
                        dc.b $22 ; 
                        dc.b $1c ; ...###..
                        dc.b $25 ; 
                        dc.b $0e ; ....###.
                        dc.b $28 ; 
                        dc.b $0e ; ....###.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Cave_08          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ;          ; .........##.............
                        dc.b $60 ; .##..... ; ........###..##.........
                        dc.b $16 ;          ; ......#####.###.........
                        dc.b $e6 ; ###..##. ; #######....#..#.##......
                        dc.b $18 ;          ; .#######################
                        dc.b $03 ; ......## ; ..######################
                        dc.b $19 ; 
                        dc.b $ee ; ###.###.
                        dc.b $1b ; 
                        dc.b $fe ; #######.
                        dc.b $1c ; 
                        dc.b $12 ; ...#..#.
                        dc.b $1d ; 
                        dc.b $c0 ; ##......
                        dc.b $1e ; 
                        dc.b $7f ; .#######
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $ff ; ########
                        dc.b $21 ; 
                        dc.b $3f ; ..######
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $ff ; ########
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Cave_09          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0c ;          ; ..###....##.............
                        dc.b $38 ; ..#.#... ; ..#####.###.............
                        dc.b $0d ;          ; ..#####.###.............
                        dc.b $60 ; .##..... ; ...#####.###.##.........
                        dc.b $0f ;          ; ....#####.##.##.........
                        dc.b $3e ; ..#####. ; .....######..##.........
                        dc.b $10 ;          ; .......######.#.........
                        dc.b $e0 ; ###..... ; .........########.......
                        dc.b $12 ;          ; ...........########.....
                        dc.b $3e ; ..#####. ; ..............#######...
                        dc.b $13 ;          ; .................####...
                        dc.b $e0 ; ###.....
                        dc.b $15 ; 
                        dc.b $1f ; ...#####
                        dc.b $16 ; 
                        dc.b $76 ; .###.##.
                        dc.b $18 ; 
                        dc.b $0f ; ....####
                        dc.b $19 ; 
                        dc.b $b6 ; #.##.##.
                        dc.b $1b ; 
                        dc.b $07 ; .....###
                        dc.b $1c ; 
                        dc.b $e6 ; ###..##.
                        dc.b $1e ; 
                        dc.b $01 ; .......#
                        dc.b $1f ; 
                        dc.b $fa ; #####.#.
                        dc.b $22 ; 
                        dc.b $7f ; .#######
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $25 ; 
                        dc.b $1f ; ...#####
                        dc.b $26 ; 
                        dc.b $e0 ; ###.....
                        dc.b $28 ; 
                        dc.b $03 ; ......##
                        dc.b $29 ; 
                        dc.b $f8 ; #####...
                        dc.b $2c ; 
                        dc.b $78 ; .####...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Cave_0a          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $09 ;          ; .....###................
                        dc.b $07 ; .....### ; .....###.##.............
                        dc.b $0c ;          ; .....##.###.............
                        dc.b $07 ; .....### ; .....##.###.............
                        dc.b $0d ;          ; ......##.##.##..........
                        dc.b $60 ; .##..... ; ......###.#.##..........
                        dc.b $0f ;          ; .......#######..........
                        dc.b $06 ; .....##. ; ........###.##..........
                        dc.b $10 ;          ; .........###.#.#........
                        dc.b $e0 ; ###..... ; ..........#######.......
                        dc.b $12 ;          ; ...........#######......
                        dc.b $06 ; .....##. ; ............######......
                        dc.b $13 ;          ; ..............#####.....
                        dc.b $e0 ; ###..... ; ................###.....
                        dc.b $15 ; 
                        dc.b $03 ; ......##
                        dc.b $16 ; 
                        dc.b $6c ; .##.##..
                        dc.b $18 ; 
                        dc.b $03 ; ......##
                        dc.b $19 ; 
                        dc.b $ac ; #.#.##..
                        dc.b $1b ; 
                        dc.b $01 ; .......#
                        dc.b $1c ; 
                        dc.b $fc ; ######..
                        dc.b $1f ; 
                        dc.b $ec ; ###.##..
                        dc.b $22 ; 
                        dc.b $75 ; .###.#.#
                        dc.b $25 ; 
                        dc.b $3f ; ..######
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $1f ; ...#####
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2b ; 
                        dc.b $0f ; ....####
                        dc.b $2c ; 
                        dc.b $c0 ; ##......
                        dc.b $2e ; 
                        dc.b $03 ; ......##
                        dc.b $2f ; 
                        dc.b $e0 ; ###.....
                        dc.b $32 ; 
                        dc.b $e0 ; ###.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Cave_0b          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ;          ; ........##..............
                        dc.b $c0 ; ##...... ; .......##.##............
                        dc.b $0c ;          ; .......##.##............
                        dc.b $01 ; .......# ; .......##.##............
                        dc.b $0d ;          ; ........##..##..........
                        dc.b $b0 ; #.##.... ; ........###.##..........
                        dc.b $0f ;          ; .........##.##..........
                        dc.b $01 ; .......# ; .........##..#.#........
                        dc.b $10 ;          ; ..........###.##........
                        dc.b $b0 ; #.##.... ; ...........#####........
                        dc.b $12 ;          ; ............#####.......
                        dc.b $01 ; .......# ; .............####.......
                        dc.b $13 ;          ; ..............####......
                        dc.b $b0 ; #.##.... ; ...............##.......
                        dc.b $16 ; 
                        dc.b $cc ; ##..##..
                        dc.b $19 ; 
                        dc.b $ec ; ###.##..
                        dc.b $1c ; 
                        dc.b $6c ; .##.##..
                        dc.b $1f ; 
                        dc.b $65 ; .##..#.#
                        dc.b $22 ; 
                        dc.b $3b ; ..###.##
                        dc.b $25 ; 
                        dc.b $1f ; ...#####
                        dc.b $28 ; 
                        dc.b $0f ; ....####
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $07 ; .....###
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $03 ; ......##
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        dc.b $31 ; 
                        dc.b $01 ; .......#
                        dc.b $32 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Cave_0c          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ...........##...........
                        dc.b $0d ;          ; .........##..##.........
                        dc.b $18 ; ...##... ; .........#.##.#.........
                        dc.b $10 ;          ; ........##.##.##........
                        dc.b $66 ; .##..##. ; ........##.##.##........
                        dc.b $13 ;          ; ........###..###........
                        dc.b $5a ; .#.##.#. ; ........#.####.#........
                        dc.b $16 ;          ; ........###..###........
                        dc.b $db ; ##.##.## ; ........########........
                        dc.b $19 ;          ; .........######.........
                        dc.b $db ; ##.##.## ; .........######.........
                        dc.b $1c ;          ; ..........####..........
                        dc.b $e7 ; ###..### ; ..........####..........
                        dc.b $1f ; 
                        dc.b $bd ; #.####.#
                        dc.b $22 ; 
                        dc.b $e7 ; ###..###
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $2b ; 
                        dc.b $7e ; .######.
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_00         equ  *
SP_Dat_Ship_23          equ  *
SP_Dat_Cave_0d          dc.b $00 ; <flag: full sprite data>
                                                
                        dc.b $00, $30, $00  ; ..........##............
                        dc.b $00, $70, $00  ; .........###............
                        dc.b $00, $78, $38  ; .........####.....###...
                        dc.b $33, $9c, $f8  ; ..##..###..###..#####...
                        dc.b $7f, $ff, $f0  ; .###################....
                        dc.b $33, $f7, $a0  ; ..##..######.####.#.....
                        dc.b $1e, $fc, $e0  ; ...####.######..###.....
                        dc.b $3f, $9f, $fc  ; ..#######..###########..
                        dc.b $7f, $f9, $be  ; .############..##.#####.
                        dc.b $f9, $ff, $f8  ; #####..##############...
                        dc.b $df, $fe, $e0  ; ##.############.###.....
                        dc.b $3f, $cf, $f0  ; ..########..########....
                        dc.b $13, $ff, $f8  ; ...#..###############...
                        dc.b $1f, $fe, $78  ; ...############..####...
                        dc.b $3f, $9f, $c0  ; ..#######..#######......
                        dc.b $7b, $ff, $e0  ; .####.#############.....
                        dc.b $4b, $f4, $e0  ; .#..#.######.#..###.....
                        dc.b $03, $43, $b0  ; ......##.#....###.##....
                        dc.b $07, $c0, $f0  ; .....#####......####....
                        dc.b $01, $80, $30  ; .......##.........##....
                        dc.b $00, $00, $00  ; ........................
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_0f         equ  *              ; .hbu004.
SP_Dat_Cave_0e          dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $30, $00  ; ..........##............
                        dc.b $00, $40, $00  ; .........#..............
                        dc.b $00, $68, $18  ; .........##.#......##...
                        dc.b $33, $84, $48  ; ..##..###....#...#..#...
                        dc.b $6c, $6b, $70  ; .##.##...##.#.##.###....
                        dc.b $13, $25, $20  ; ...#..##..#..#.#..#.....
                        dc.b $0a, $68, $80  ; ....#.#..##.#...#.......
                        dc.b $31, $1a, $d4  ; ..##...#...##.#.##.#.#..
                        dc.b $4e, $61, $2c  ; .#..###..##....#..#.##..
                        dc.b $58, $95, $d8  ; .#.##...#..#.#.###.##...
                        dc.b $82, $a2, $a0  ; #.....#.#.#...#.#.#.....
                        dc.b $2d, $4d, $30  ; ..#.##.#.#..##.#..##....
                        dc.b $11, $24, $d8  ; ...#...#..#..#..##.##...
                        dc.b $0e, $b2, $68  ; ....###.#.##..#..##.#...
                        dc.b $29, $1b, $40  ; ..#.#..#...##.##.#......
                        dc.b $73, $69, $a0  ; .###..##.##.#..##.#.....
                        dc.b $08, $14, $e0  ; ....#......#.#..###.....
                        dc.b $02, $42, $b0  ; ......#..#....#.#.##....
                        dc.b $06, $80, $c0  ; .....##.#.......##......
                        dc.b $01, $00, $30  ; .......#..........##....
                        dc.b $00, $00, $00  ; ........................
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_10         equ  *              ; .hbu004.
SP_Dat_Cave_0f          dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $40, $10  ; .........#.........#....
                        dc.b $30, $84, $08  ; ..##....#....#......#...
                        dc.b $0c, $43, $40  ; ....##...#....##.#......
                        dc.b $02, $00, $20  ; ......#...........#.....
                        dc.b $02, $28, $00  ; ......#...#.#...........
                        dc.b $20, $1a, $44  ; ..#........##.#..#...#..
                        dc.b $08, $41, $0c  ; ....#....#.....#....##..
                        dc.b $18, $81, $80  ; ...##...#......##.......
                        dc.b $02, $02, $00  ; ......#.......#.........
                        dc.b $05, $08, $20  ; .....#.#....#.....#.....
                        dc.b $01, $04, $c0  ; .......#.....#..##......
                        dc.b $04, $82, $48  ; .....#..#.....#..#..#...
                        dc.b $28, $03, $00  ; ..#.#.........##........
                        dc.b $50, $61, $00  ; .#.#.....##....#........
                        dc.b $00, $10, $40  ; ...........#.....#......
                        dc.b $02, $00, $a0  ; ......#.........#.#.....
                        dc.b $06, $00, $00  ; .....##.................
                        dc.b $00, $00, $30  ; ..................##....
                        dc.b $00, $00, $00  ; ........................
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_24          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ...........##...........
                        dc.b $1c ;          ; ...........##...........
                        dc.b $18 ; ...##...
                        dc.b $1f ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_25          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ..........####..........
                        dc.b $13 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; ..........####..........
                        dc.b $16 ;          ; ...........##...........
                        dc.b $3c ; ..####.. ; ...........##...........
                        dc.b $19 ; 
                        dc.b $3c ; ..####..
                        dc.b $1c ; 
                        dc.b $18 ; ...##...
                        dc.b $1f ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_26          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $07 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $0a ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $0d ;          ; .........######.........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $10 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ...........##...........
                        dc.b $13 ;          ; ...........##...........
                        dc.b $7e ; .######.
                        dc.b $16 ; 
                        dc.b $3c ; ..####..
                        dc.b $19 ; 
                        dc.b $3c ; ..####..
                        dc.b $1c ; 
                        dc.b $18 ; ...##...
                        dc.b $1f ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_27          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $22 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ..........###...........
                        dc.b $25 ;          ; ..........####..........
                        dc.b $38 ; ..###... ; .........######.........
                        dc.b $28 ;          ; .........######.........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $2b ;          ; .........#####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $2e ;          ; ...........##...........
                        dc.b $7e ; .######. ; ...........##...........
                        dc.b $31 ; 
                        dc.b $7e ; .######.
                        dc.b $34 ; 
                        dc.b $7c ; .#####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $18 ; ...##...
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_28          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ..........###...........
                        dc.b $1c ;          ; ..........####..........
                        dc.b $38 ; ..###... ; .........#####..........
                        dc.b $1f ;          ; .........######.........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $22 ;          ; .........######.........
                        dc.b $7c ; .#####.. ; .........######.........
                        dc.b $25 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........#####..........
                        dc.b $28 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ...........##...........
                        dc.b $2b ;          ; ...........##...........
                        dc.b $7e ; .######.
                        dc.b $2e ; 
                        dc.b $7e ; .######.
                        dc.b $31 ; 
                        dc.b $7e ; .######.
                        dc.b $34 ; 
                        dc.b $7c ; .#####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $18 ; ...##...
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_29          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ..........###...........
                        dc.b $13 ;          ; ..........####..........
                        dc.b $38 ; ..###... ; .........#####..........
                        dc.b $16 ;          ; .........######.........
                        dc.b $3c ; ..####.. ; ........########........
                        dc.b $19 ;          ; ........########........
                        dc.b $7c ; .#####.. ; ........########........
                        dc.b $1c ;          ; ........########........
                        dc.b $7e ; .######. ; ........########........
                        dc.b $1f ;          ; ........########........
                        dc.b $ff ; ######## ; .........######.........
                        dc.b $22 ;          ; .........#####..........
                        dc.b $ff ; ######## ; ..........####..........
                        dc.b $25 ;          ; ...........##...........
                        dc.b $ff ; ######## ; ...........##...........
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $ff ; ########
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $31 ; 
                        dc.b $7e ; .######.
                        dc.b $34 ; 
                        dc.b $7c ; .#####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $18 ; ...##...
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_2a          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $07 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ...........###..........
                        dc.b $0a ;          ; ..........####..........
                        dc.b $1c ; ...###.. ; .........######.........
                        dc.b $0d ;          ; .........#######........
                        dc.b $3c ; ..####.. ; ........########........
                        dc.b $10 ;          ; .......#########........
                        dc.b $7e ; .######. ; .......##########.......
                        dc.b $13 ;          ; .......##########.......
                        dc.b $7f ; .####### ; .......##########.......
                        dc.b $16 ;          ; .......##########.......
                        dc.b $ff ; ######## ; .......##########.......
                        dc.b $18 ;          ; ........########........
                        dc.b $01 ; .......# ; ........########........
                        dc.b $19 ;          ; .........######.........
                        dc.b $ff ; ######## ; .........#####..........
                        dc.b $1b ;          ; ..........####..........
                        dc.b $01 ; .......# ; ...........##...........
                        dc.b $1c ;          ; ...........##...........
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $80 ; #.......
                        dc.b $1e ; 
                        dc.b $01 ; .......#
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $21 ; 
                        dc.b $01 ; .......#
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $24 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $ff ; ########
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $31 ; 
                        dc.b $7e ; .######.
                        dc.b $34 ; 
                        dc.b $7c ; .#####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $18 ; ...##...
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_2b          dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $18, $00  ; ...........##...........
                        dc.b $00, $38, $00  ; ..........###...........
                        dc.b $00, $3c, $00  ; ..........####..........
                        dc.b $00, $7e, $00  ; .........######.........
                        dc.b $00, $ff, $00  ; ........########........
                        dc.b $00, $ff, $00  ; ........########........
                        dc.b $01, $ff, $80  ; .......##########.......
                        dc.b $01, $ff, $80  ; .......##########.......
                        dc.b $01, $ff, $80  ; .......##########.......
                        dc.b $01, $ff, $80  ; .......##########.......
                        dc.b $01, $ff, $80  ; .......##########.......
                        dc.b $01, $ff, $80  ; .......##########.......
                        dc.b $00, $ff, $80  ; ........#########.......
                        dc.b $00, $ff, $00  ; ........########........
                        dc.b $00, $7e, $00  ; .........######.........
                        dc.b $00, $7c, $00  ; .........#####..........
                        dc.b $00, $3c, $00  ; ..........####..........
                        dc.b $00, $38, $00  ; ..........###...........
                        dc.b $00, $18, $00  ; ...........##...........
                        dc.b $00, $18, $00  ; ...........##...........
                        dc.b $00, $18, $00  ; ...........##...........
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_2c          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ..........#..#..........
                        dc.b $0d ;          ; ..........###...........
                        dc.b $24 ; ..#..#.. ; .........#..###.........
                        dc.b $10 ;          ; ........#.####.#........
                        dc.b $38 ; ..###... ; .........#.#.###........
                        dc.b $13 ;          ; .......####.#.#.#.......
                        dc.b $4e ; .#..###. ; .......##.#..####.......
                        dc.b $16 ;          ; .........#.###.#........
                        dc.b $bd ; #.####.# ; .......####.#.###.......
                        dc.b $19 ;          ; ........#..#.##.#.......
                        dc.b $57 ; .#.#.### ; .........####.###.......
                        dc.b $1b ;          ; ........#.#.##.#........
                        dc.b $01 ; .......# ; ..........#.###.........
                        dc.b $1c ;          ; .........#...#..........
                        dc.b $ea ; ###.#.#. ; ........................
                        dc.b $1d ;          ; ...........#............
                        dc.b $80 ; #....... ; ...........##...........
                        dc.b $1e ; 
                        dc.b $01 ; .......#
                        dc.b $1f ; 
                        dc.b $a7 ; #.#..###
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $5d ; .#.###.#
                        dc.b $24 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $eb ; ###.#.##
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $96 ; #..#.##.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $7b ; .####.##
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $ad ; #.#.##.#
                        dc.b $31 ; 
                        dc.b $2e ; ..#.###.
                        dc.b $34 ; 
                        dc.b $44 ; .#...#..
                        dc.b $3a ; 
                        dc.b $10 ; ...#....
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_2d          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ;          ; ............#...........
                        dc.b $08 ; ....#... ; ..........#.............
                        dc.b $16 ;          ; ..........#.#...........
                        dc.b $20 ; ..#..... ; .........#.#.##.........
                        dc.b $19 ;          ; ........##..##.#........
                        dc.b $28 ; ..#.#... ; .........#...#.#........
                        dc.b $1c ;          ; ..........##.##.#.......
                        dc.b $56 ; .#.#.##. ; .......#.##.###.#.......
                        dc.b $1f ;          ; .......#...##.##........
                        dc.b $cd ; ##..##.# ; ..........##..#.#.......
                        dc.b $22 ;          ; ........#.######........
                        dc.b $45 ; .#...#.# ; ........##..#.#.........
                        dc.b $25 ;          ; .........###.##.........
                        dc.b $36 ; ..##.##. ; .........#..#...........
                        dc.b $26 ;          ; ..........#..#..........
                        dc.b $80 ; #.......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $6e ; .##.###.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2a ; 
                        dc.b $01 ; .......#
                        dc.b $2b ; 
                        dc.b $1b ; ...##.##
                        dc.b $2e ; 
                        dc.b $32 ; ..##..#.
                        dc.b $2f ; 
                        dc.b $80 ; #.......
                        dc.b $31 ; 
                        dc.b $bf ; #.######
                        dc.b $34 ; 
                        dc.b $ca ; ##..#.#.
                        dc.b $37 ; 
                        dc.b $76 ; .###.##.
                        dc.b $3a ; 
                        dc.b $48 ; .#..#...
                        dc.b $3d ; 
                        dc.b $24 ; ..#..#..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_2e          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1c ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ..........#.#...........
                        dc.b $1f ;          ; ...........#............
                        dc.b $28 ; ..#.#... ; ............###.........
                        dc.b $22 ;          ; .........##...##........
                        dc.b $10 ; ...#.... ; ........#.##............
                        dc.b $25 ;          ; .......#.#..#...#.......
                        dc.b $0e ; ....###. ; ...........##...........
                        dc.b $28 ;          ; .......##.##...##.......
                        dc.b $63 ; .##...## ; ..........#..##.........
                        dc.b $2b ;          ; ........#..##...........
                        dc.b $b0 ; #.##.... ; ...........#............
                        dc.b $2d ; 
                        dc.b $01 ; .......#
                        dc.b $2e ; 
                        dc.b $48 ; .#..#...
                        dc.b $2f ; 
                        dc.b $80 ; #.......
                        dc.b $31 ; 
                        dc.b $18 ; ...##...
                        dc.b $33 ; 
                        dc.b $01 ; .......#
                        dc.b $34 ; 
                        dc.b $b1 ; #.##...#
                        dc.b $35 ; 
                        dc.b $80 ; #.......
                        dc.b $37 ; 
                        dc.b $26 ; ..#..##.
                        dc.b $3a ; 
                        dc.b $98 ; #..##...
                        dc.b $3d ; 
                        dc.b $10 ; ...#....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_2f          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $25 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ............##..........
                        dc.b $28 ;          ; ..........##............
                        dc.b $0c ; ....##.. ; .........##..##.........
                        dc.b $2b ;          ; ...........##...........
                        dc.b $30 ; ..##.... ; ........##..##.#........
                        dc.b $2e ;          ; .......#..#....##.......
                        dc.b $66 ; .##..##. ; .......##...##..........
                        dc.b $31 ;          ; ..........##............
                        dc.b $18 ; ...##...
                        dc.b $34 ; 
                        dc.b $cd ; ##..##.#
                        dc.b $36 ; 
                        dc.b $01 ; .......#
                        dc.b $37 ; 
                        dc.b $21 ; ..#....#
                        dc.b $38 ; 
                        dc.b $80 ; #.......
                        dc.b $39 ; 
                        dc.b $01 ; .......#
                        dc.b $3a ; 
                        dc.b $8c ; #...##..
                        dc.b $3d ; 
                        dc.b $30 ; ..##....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_30          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $2e ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ........................
                        dc.b $34 ;          ; ............##..........
                        dc.b $0c ; ....##.. ; .........##.............
                        dc.b $37 ;          ; ........##..#.##........
                        dc.b $60 ; .##..... ; ...........##...........
                        dc.b $3a ; 
                        dc.b $cb ; ##..#.##
                        dc.b $3d ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_31          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $37 ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ........................
                        dc.b $3d ;          ; ..........#..#..........
                        dc.b $24 ; ..#..#..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_32          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $27 ;          ; ..................................#.....................................
                        dc.b $04 ; .....#.. ; .................................###....................................
                        dc.b $28 ;          ; ..................................#...#.................................
                        dc.b $44 ; .#...#.. ; .................................###..##................................
                        dc.b $29 ;          ; .................................#######................................
                        dc.b $44 ; .#...#.. ; ................................########................................
                        dc.b $2a ;          ; ..............................############..............................
                        dc.b $ff ; ######## ; ................................########................................
                        dc.b $2b ;          ; .....#...#...#...#...#..........############........#...#...#...#.......
                        dc.b $ff ; ######## ; ########################################################################
                        dc.b $2c ;          ; ....################################################################....
                        dc.b $ff ; ######## ; ......##############################################################....
                        dc.b $2d ;          ; ......############################################################......
                        dc.b $0f ; ....####
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $2f ; 
                        dc.b $ff ; ########
                        dc.b $30 ; 
                        dc.b $03 ; ......##
                        dc.b $31 ; 
                        dc.b $ff ; ########
                        dc.b $32 ; 
                        dc.b $ff ; ########
                        dc.b $33 ; 
                        dc.b $03 ; ......##
                        dc.b $34 ; 
                        dc.b $ff ; ########
                        dc.b $35 ; 
                        dc.b $ff ; ########
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_33          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ;          ; cleanup: missing 3 bytes inserted at start
                        dc.b $20 ; ..#.....
                        dc.b $13 ; 
                        dc.b $70 ; .###....
                        dc.b $16 ; 
                        dc.b $22 ; ..#...#.
                        dc.b $19 ; 
                        dc.b $73 ; .###..##
                        dc.b $1c ; 
                        dc.b $7f ; .#######
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $21 ; 
                        dc.b $03 ; ......##
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $40 ; .#......
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $29 ; 
                        dc.b $f0 ; ####....
                        dc.b $2a ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $ff ; ########
                        dc.b $2c ; 
                        dc.b $ff ; ########
                        dc.b $2d ; 
                        dc.b $ff ; ########
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $2f ; 
                        dc.b $ff ; ########
                        dc.b $30 ; 
                        dc.b $ff ; ########
                        dc.b $31 ; 
                        dc.b $ff ; ########
                        dc.b $32 ; 
                        dc.b $ff ; ########
                        dc.b $33 ; 
                        dc.b $ff ; ########
                        dc.b $34 ; 
                        dc.b $ff ; ########
                        dc.b $35 ; 
                        dc.b $ff ; ########
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_34          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $27 ; 
                        dc.b $08 ; ....#...
                        dc.b $28 ; 
                        dc.b $88 ; #...#...
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2a ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $ff ; ########
                        dc.b $2c ; 
                        dc.b $ff ; ########
                        dc.b $2d ; 
                        dc.b $ff ; ########
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $2f ; 
                        dc.b $f0 ; ####....
                        dc.b $30 ; 
                        dc.b $ff ; ########
                        dc.b $31 ; 
                        dc.b $ff ; ########
                        dc.b $32 ; 
                        dc.b $f0 ; ####....
                        dc.b $33 ; 
                        dc.b $ff ; ########
                        dc.b $34 ; 
                        dc.b $ff ; ########
                        dc.b $35 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_35          dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
                        dc.b $ff, $ff, $ff  ; ########################
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_36          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ;          ; .......#................
                        dc.b $01 ; .......# ; ......###...............
                        dc.b $18 ;          ; .......#................
                        dc.b $03 ; ......## ; ......###...............
                        dc.b $19 ;          ; .....#####..............
                        dc.b $80 ; #....... ; ....#######.............
                        dc.b $1b ;          ; ...#########............
                        dc.b $01 ; .......# ; ...#########............
                        dc.b $1e ;          ; ...#########............
                        dc.b $03 ; ......##
                        dc.b $1f ; 
                        dc.b $80 ; #.......
                        dc.b $21 ; 
                        dc.b $07 ; .....###
                        dc.b $22 ; 
                        dc.b $c0 ; ##......
                        dc.b $24 ; 
                        dc.b $0f ; ....####
                        dc.b $25 ; 
                        dc.b $e0 ; ###.....
                        dc.b $27 ; 
                        dc.b $1f ; ...#####
                        dc.b $28 ; 
                        dc.b $f0 ; ####....
                        dc.b $2a ; 
                        dc.b $1f ; ...#####
                        dc.b $2b ; 
                        dc.b $f0 ; ####....
                        dc.b $2d ; 
                        dc.b $1f ; ...#####
                        dc.b $2e ; 
                        dc.b $f0 ; ####....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_37          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $25 ;          ; .........#..............
                        dc.b $40 ; .#...... ; .........##.............
                        dc.b $28 ;          ; .......#####............
                        dc.b $60 ; .##..... ; .....###########........
                        dc.b $2a ;          ; ##############..........
                        dc.b $01 ; .......#
                        dc.b $2b ; 
                        dc.b $f0 ; ####....
                        dc.b $2d ; 
                        dc.b $07 ; .....###
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $30 ; 
                        dc.b $ff ; ########
                        dc.b $31 ; 
                        dc.b $fc ; ######..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_38          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $22 ;          ; ...........#............
                        dc.b $10 ; ...#.... ; ..........###...........
                        dc.b $25 ;          ; .........#####..........
                        dc.b $38 ; ..###... ; ........#######.........
                        dc.b $28 ;          ; ........#######.........
                        dc.b $7c ; .#####..
                        dc.b $2b ; 
                        dc.b $fe ; #######.
                        dc.b $2e ; 
                        dc.b $fe ; #######.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Ship_39          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ;          ; ......#.................
                        dc.b $02 ; ......#. ; ......#.#...............
                        dc.b $1b ;          ; .....####...............
                        dc.b $02 ; ......#. ; #########...............
                        dc.b $1c ;          ; ..##########............
                        dc.b $80 ; #....... ; ...#############........
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $80 ; #.......
                        dc.b $21 ; 
                        dc.b $ff ; ########
                        dc.b $22 ; 
                        dc.b $80 ; #.......
                        dc.b $24 ; 
                        dc.b $3f ; ..######
                        dc.b $25 ; 
                        dc.b $f0 ; ####....
                        dc.b $27 ; 
                        dc.b $1f ; ...#####
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_01         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;           ..........########......
                        dc.b $3f ; ..######  ..........########......
                        dc.b $1a ;           ##########.#.#.#.##.#...
                        dc.b $c0 ; ##......  ....#.#.#..#.#.#.##.#...
                        dc.b $1c ;           ....#.#.#.#.#.#.#.#.#...
                        dc.b $3f ; ..######  ....##.###.###.###.###..
                        dc.b $1d ;           .....###############.#..
                        dc.b $c0 ; ##......  ....##.###.###.###.###..
                        dc.b $1e ; 
                        dc.b $ff ; ########
                        dc.b $1f ; 
                        dc.b $d5 ; ##.#.#.#
                        dc.b $20 ; 
                        dc.b $68 ; .##.#...
                        dc.b $21 ; 
                        dc.b $0a ; ....#.#.
                        dc.b $22 ; 
                        dc.b $95 ; #..#.#.#
                        dc.b $23 ; 
                        dc.b $68 ; .##.#...
                        dc.b $24 ; 
                        dc.b $0a ; ....#.#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $27 ; 
                        dc.b $0d ; ....##.#
                        dc.b $28 ; 
                        dc.b $dd ; ##.###.#
                        dc.b $29 ; 
                        dc.b $dc ; ##.###..
                        dc.b $2a ; 
                        dc.b $07 ; .....###
                        dc.b $2b ; 
                        dc.b $ff ; ########
                        dc.b $2c ; 
                        dc.b $f4 ; ####.#..
                        dc.b $2d ; 
                        dc.b $0d ; ....##.#
                        dc.b $2e ; 
                        dc.b $dd ; ##.###.#
                        dc.b $2f ; 
                        dc.b $dc ; ##.###..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_02         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $16 ;          ; ........#.#.............
                        dc.b $a0 ; #.#..... ; ......#.#.########......
                        dc.b $18 ;          ; ....#.#.#.########......
                        dc.b $02 ; ......#. ; ##########.#.#.#.##.....
                        dc.b $19 ;          ; ....#####..#.#.#.##.#...
                        dc.b $bf ; #.###### ; ....#######.#.#.#.#.##..
                        dc.b $1a ;          ; ......#######.#.#..###..
                        dc.b $c0 ; ##...... ; ........#######..#.###..
                        dc.b $1b ;          ; ..........######.#.#....
                        dc.b $0a ; ....#.#. ; ............####.#......
                        dc.b $1c ;          ; ..............##........
                        dc.b $bf ; #.######
                        dc.b $1d ; 
                        dc.b $c0 ; ##......
                        dc.b $1e ; 
                        dc.b $ff ; ########
                        dc.b $1f ; 
                        dc.b $d5 ; ##.#.#.#
                        dc.b $20 ; 
                        dc.b $60 ; .##.....
                        dc.b $21 ; 
                        dc.b $0f ; ....####
                        dc.b $22 ; 
                        dc.b $95 ; #..#.#.#
                        dc.b $23 ; 
                        dc.b $68 ; .##.#...
                        dc.b $24 ; 
                        dc.b $0f ; ....####
                        dc.b $25 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $26 ; 
                        dc.b $ac ; #.#.##..
                        dc.b $27 ; 
                        dc.b $03 ; ......##
                        dc.b $28 ; 
                        dc.b $fa ; #####.#.
                        dc.b $29 ; 
                        dc.b $9c ; #..###..
                        dc.b $2b ; 
                        dc.b $fe ; #######.
                        dc.b $2c ; 
                        dc.b $5c ; .#.###..
                        dc.b $2e ; 
                        dc.b $3f ; ..######
                        dc.b $2f ; 
                        dc.b $50 ; .#.#....
                        dc.b $31 ; 
                        dc.b $0f ; ....####
                        dc.b $32 ; 
                        dc.b $40 ; .#......
                        dc.b $34 ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_03         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ..........########......
                        dc.b $3f ; ..###### ; ..........#########.....
                        dc.b $1a ;          ; ##########.#.#.#.##.#...
                        dc.b $c0 ; ##...... ; ........#..#.#.#.##.##..
                        dc.b $1c ;          ; ......#.#.#.#.#.#.####..
                        dc.b $3f ; ..###### ; ....###.#.#.#.#.######..
                        dc.b $1d ;          ; ....##.##.#.#.######....
                        dc.b $e0 ; ###..... ; ....##.#.##.######......
                        dc.b $1e ;          ; .......#.#######........
                        dc.b $ff ; ######## ; .........#####..........
                        dc.b $1f ;          ; ..........##............
                        dc.b $d5 ; ##.#.#.#
                        dc.b $20 ; 
                        dc.b $68 ; .##.#...
                        dc.b $22 ; 
                        dc.b $95 ; #..#.#.#
                        dc.b $23 ; 
                        dc.b $6c ; .##.##..
                        dc.b $24 ; 
                        dc.b $02 ; ......#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $bc ; #.####..
                        dc.b $27 ; 
                        dc.b $0e ; ....###.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $fc ; ######..
                        dc.b $2a ; 
                        dc.b $0d ; ....##.#
                        dc.b $2b ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $2c ; 
                        dc.b $f0 ; ####....
                        dc.b $2d ; 
                        dc.b $0d ; ....##.#
                        dc.b $2e ; 
                        dc.b $6f ; .##.####
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        dc.b $30 ; 
                        dc.b $01 ; .......#
                        dc.b $31 ; 
                        dc.b $7f ; .#######
                        dc.b $34 ; 
                        dc.b $7c ; .#####..
                        dc.b $37 ; 
                        dc.b $30 ; ..##....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_04         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1e ;           #####...................
                        dc.b $f8 ; #####...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_05         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $20 ;           ...................#####
                        dc.b $1f ; ...#####
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_06         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $12 ;          ; ....#.#.#.#.............
                        dc.b $0a ; ....#.#. ; ..#.#.#.#.#.#...........
                        dc.b $13 ;          ; #.#.#.#.#.#.#.#.........
                        dc.b $a0 ; #.#..... ; #.#.#.#.#.#.#.#.........
                        dc.b $15 ;          ; .##.#.#.#.#.#..#########
                        dc.b $2a ; ..#.#.#. ; .#.##.#.#.#..#.#........
                        dc.b $16 ;          ; .#.#.#.#.#.#.#.#........
                        dc.b $a8 ; #.#.#... ; #..#.#.#.#.#.##.........
                        dc.b $18 ;          ; ..#..#.#.#.##...........
                        dc.b $aa ; #.#.#.#. ; ....#.#.#.#.............
                        dc.b $19 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $1b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $1c ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $1e ; 
                        dc.b $6a ; .##.#.#.
                        dc.b $1f ; 
                        dc.b $a9 ; #.#.#..#
                        dc.b $20 ; 
                        dc.b $ff ; ########
                        dc.b $21 ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $22 ; 
                        dc.b $a5 ; #.#..#.#
                        dc.b $24 ; 
                        dc.b $55 ; .#.#.#.#
                        dc.b $25 ; 
                        dc.b $55 ; .#.#.#.#
                        dc.b $27 ; 
                        dc.b $95 ; #..#.#.#
                        dc.b $28 ; 
                        dc.b $56 ; .#.#.##.
                        dc.b $2a ; 
                        dc.b $25 ; ..#..#.#
                        dc.b $2b ; 
                        dc.b $58 ; .#.##...
                        dc.b $2d ; 
                        dc.b $0a ; ....#.#.
                        dc.b $2e ; 
                        dc.b $a0 ; #.#.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_07         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ........#.#.#.#.........
                        dc.b $aa ; #.#.#.#. ; ........#.#.#.#.........
                        dc.b $1c ;          ; ......###.#.#.#.########
                        dc.b $aa ; #.#.#.#. ; .......##.#.#.#..#......
                        dc.b $1e ;          ; ......##.#.#.#.###......
                        dc.b $03 ; ......## ; .......#.#.#.#.#.#......
                        dc.b $1f ;          ; ......###.#.#.#.##......
                        dc.b $aa ; #.#.#.#. ; .......##.#.#.#..#......
                        dc.b $20 ;          ; ......##.#.#.#.###......
                        dc.b $ff ; ######## ; ......##.#.#.#.###......
                        dc.b $21 ;          ; ......##........##......
                        dc.b $01 ; .......#
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $40 ; .#......
                        dc.b $24 ; 
                        dc.b $03 ; ......##
                        dc.b $25 ; 
                        dc.b $55 ; .#.#.#.#
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $55 ; .#.#.#.#
                        dc.b $29 ; 
                        dc.b $40 ; .#......
                        dc.b $2a ; 
                        dc.b $03 ; ......##
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2c ; 
                        dc.b $c0 ; ##......
                        dc.b $2d ; 
                        dc.b $01 ; .......#
                        dc.b $2e ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2f ; 
                        dc.b $40 ; .#......
                        dc.b $30 ; 
                        dc.b $03 ; ......##
                        dc.b $31 ; 
                        dc.b $55 ; .#.#.#.#
                        dc.b $32 ; 
                        dc.b $c0 ; ##......
                        dc.b $33 ; 
                        dc.b $03 ; ......##
                        dc.b $34 ; 
                        dc.b $55 ; .#.#.#.#
                        dc.b $35 ; 
                        dc.b $c0 ; ##......
                        dc.b $36 ; 
                        dc.b $03 ; ......##
                        dc.b $38 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_08         dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $80, $00  ; ........#...............
                        dc.b $00, $60, $00  ; .........##.............
                        dc.b $03, $58, $00  ; ......##.#.##...........
                        dc.b $03, $d6, $00  ; ......####.#.##.........
                        dc.b $33, $05, $80  ; ..##..##.....#.##.......
                        dc.b $3c, $01, $60  ; ..####.........#.##.....
                        dc.b $33, $f0, $60  ; ..##..######.....##.....
                        dc.b $33, $ff, $ff  ; ..##..##################
                        dc.b $33, $00, $20  ; ..##..##..........#.....
                        dc.b $0c, $c0, $20  ; ....##..##........#.....
                        dc.b $30, $30, $20  ; ..##......##......#.....
                        dc.b $03, $00, $a0  ; ......##........#.#.....
                        dc.b $03, $c2, $a0  ; ......####....#.#.#.....
                        dc.b $03, $0a, $80  ; ......##....#.#.#.......
                        dc.b $0f, $2a, $00  ; ....####..#.#.#.........
                        dc.b $00, $a8, $00  ; ........#.#.#...........
                        dc.b $00, $a0, $00  ; ........#.#.............
                        dc.b $00, $80, $00  ; ........#...............
                        
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_09         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ;          ; ........#...............
                        dc.b $80 ; #....... ; ......#.#.#.............
                        dc.b $15 ;          ; ....#.#.#.#.#...........
                        dc.b $02 ; ......#. ; ..#.#.#.#.#.#.#.........
                        dc.b $16 ;          ; ...##.#.#.#.#..#########
                        dc.b $a0 ; #.#..... ; ...#.##.#.#..#.#........
                        dc.b $18 ;          ; ...#.#.##..#.#.#........
                        dc.b $0a ; ....#.#. ; ..##.#.#.#.#.###........
                        dc.b $19 ;          ; ..##...#.#.#..##........
                        dc.b $a8 ; #.#.#... ; ..##.....#....##........
                        dc.b $1b ;          ; ..##....##....##........
                        dc.b $2a ; ..#.#.#. ; ..##....##....##........
                        dc.b $1c ;          ; ........##..............
                        dc.b $aa ; #.#.#.#. ; ........##..............
                        dc.b $1e ;          ; ........##..............
                        dc.b $1a ; ...##.#.
                        dc.b $1f ; 
                        dc.b $a9 ; #.#.#..#
                        dc.b $20 ; 
                        dc.b $ff ; ########
                        dc.b $21 ; 
                        dc.b $16 ; ...#.##.
                        dc.b $22 ; 
                        dc.b $a5 ; #.#..#.#
                        dc.b $24 ; 
                        dc.b $15 ; ...#.#.#
                        dc.b $25 ; 
                        dc.b $95 ; #..#.#.#
                        dc.b $27 ; 
                        dc.b $35 ; ..##.#.#
                        dc.b $28 ; 
                        dc.b $57 ; .#.#.###
                        dc.b $2a ; 
                        dc.b $31 ; ..##...#
                        dc.b $2b ; 
                        dc.b $53 ; .#.#..##
                        dc.b $2d ; 
                        dc.b $30 ; ..##....
                        dc.b $2e ; 
                        dc.b $43 ; .#....##
                        dc.b $30 ; 
                        dc.b $30 ; ..##....
                        dc.b $31 ; 
                        dc.b $c3 ; ##....##
                        dc.b $33 ; 
                        dc.b $30 ; ..##....
                        dc.b $34 ; 
                        dc.b $c3 ; ##....##
                        dc.b $37 ; 
                        dc.b $c0 ; ##......
                        dc.b $3a ; 
                        dc.b $c0 ; ##......
                        dc.b $3d ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_0a         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ;          ; ######...######...######
                        dc.b $fc ; ######.. ; ##..##...##..##...##..##
                        dc.b $16 ;          ; ...###...##..##...##..##
                        dc.b $7e ; .######. ; .###.....##..##...##..##
                        dc.b $17 ;          ; ##.......##..##...##..##
                        dc.b $3f ; ..###### ; ##..##...##..##...##..##
                        dc.b $18 ;          ; ######...######...######
                        dc.b $cc ; ##..##..
                        dc.b $19 ; 
                        dc.b $66 ; .##..##.
                        dc.b $1a ; 
                        dc.b $33 ; ..##..##
                        dc.b $1b ; 
                        dc.b $1c ; ...###..
                        dc.b $1c ; 
                        dc.b $66 ; .##..##.
                        dc.b $1d ; 
                        dc.b $33 ; ..##..##
                        dc.b $1e ; 
                        dc.b $70 ; .###....
                        dc.b $1f ; 
                        dc.b $66 ; .##..##.
                        dc.b $20 ; 
                        dc.b $33 ; ..##..##
                        dc.b $21 ; 
                        dc.b $c0 ; ##......
                        dc.b $22 ; 
                        dc.b $66 ; .##..##.
                        dc.b $23 ; 
                        dc.b $33 ; ..##..##
                        dc.b $24 ; 
                        dc.b $cc ; ##..##..
                        dc.b $25 ; 
                        dc.b $66 ; .##..##.
                        dc.b $26 ; 
                        dc.b $33 ; ..##..##
                        dc.b $27 ; 
                        dc.b $fc ; ######..
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $29 ; 
                        dc.b $3f ; ..######
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_0b         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ;          ; ##..##...######...######
                        dc.b $cc ; ##..##.. ; ##..##...##..##...##..##
                        dc.b $16 ;          ; ##..##...##..##...##..##
                        dc.b $7e ; .######. ; ######...##..##...##..##
                        dc.b $17 ;          ; ....##...##..##...##..##
                        dc.b $3f ; ..###### ; ....##...##..##...##..##
                        dc.b $18 ;          ; ....##...######...######
                        dc.b $cc ; ##..##..
                        dc.b $19 ; 
                        dc.b $66 ; .##..##.
                        dc.b $1a ; 
                        dc.b $33 ; ..##..##
                        dc.b $1b ; 
                        dc.b $cc ; ##..##..
                        dc.b $1c ; 
                        dc.b $66 ; .##..##.
                        dc.b $1d ; 
                        dc.b $33 ; ..##..##
                        dc.b $1e ; 
                        dc.b $fc ; ######..
                        dc.b $1f ; 
                        dc.b $66 ; .##..##.
                        dc.b $20 ; 
                        dc.b $33 ; ..##..##
                        dc.b $21 ; 
                        dc.b $0c ; ....##..
                        dc.b $22 ; 
                        dc.b $66 ; .##..##.
                        dc.b $23 ; 
                        dc.b $33 ; ..##..##
                        dc.b $24 ; 
                        dc.b $0c ; ....##..
                        dc.b $25 ; 
                        dc.b $66 ; .##..##.
                        dc.b $26 ; 
                        dc.b $33 ; ..##..##
                        dc.b $27 ; 
                        dc.b $0c ; ....##..
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $29 ; 
                        dc.b $3f ; ..######
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_0c         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ;          ; ######...######...######
                        dc.b $fc ; ######.. ; ##..##...##..##...##..##
                        dc.b $16 ;          ; ##.......##..##...##..##
                        dc.b $7e ; .######. ; ######...##..##...##..##
                        dc.b $17 ;          ; ##..##...##..##...##..##
                        dc.b $3f ; ..###### ; ##..##...##..##...##..##
                        dc.b $18 ;          ; ######...######...######
                        dc.b $cc ; ##..##..
                        dc.b $19 ; 
                        dc.b $66 ; .##..##.
                        dc.b $1a ; 
                        dc.b $33 ; ..##..##
                        dc.b $1b ; 
                        dc.b $c0 ; ##......
                        dc.b $1c ; 
                        dc.b $66 ; .##..##.
                        dc.b $1d ; 
                        dc.b $33 ; ..##..##
                        dc.b $1e ; 
                        dc.b $fc ; ######..
                        dc.b $1f ; 
                        dc.b $66 ; .##..##.
                        dc.b $20 ; 
                        dc.b $33 ; ..##..##
                        dc.b $21 ; 
                        dc.b $cc ; ##..##..
                        dc.b $22 ; 
                        dc.b $66 ; .##..##.
                        dc.b $23 ; 
                        dc.b $33 ; ..##..##
                        dc.b $24 ; 
                        dc.b $cc ; ##..##..
                        dc.b $25 ; 
                        dc.b $66 ; .##..##.
                        dc.b $26 ; 
                        dc.b $33 ; ..##..##
                        dc.b $27 ; 
                        dc.b $fc ; ######..
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $29 ; 
                        dc.b $3f ; ..######
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_0d         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ;          ; ######...######...######
                        dc.b $fc ; ######.. ; ##..##...##..##...##..##
                        dc.b $16 ;          ; ##..##...##..##...##..##
                        dc.b $7e ; .######. ; .####....##..##...##..##
                        dc.b $17 ;          ; ##..##...##..##...##..##
                        dc.b $3f ; ..###### ; ##..##...##..##...##..##
                        dc.b $18 ;          ; ######...######...######
                        dc.b $cc ; ##..##..
                        dc.b $19 ; 
                        dc.b $66 ; .##..##.
                        dc.b $1a ; 
                        dc.b $33 ; ..##..##
                        dc.b $1b ; 
                        dc.b $cc ; ##..##..
                        dc.b $1c ; 
                        dc.b $66 ; .##..##.
                        dc.b $1d ; 
                        dc.b $33 ; ..##..##
                        dc.b $1e ; 
                        dc.b $78 ; .####...
                        dc.b $1f ; 
                        dc.b $66 ; .##..##.
                        dc.b $20 ; 
                        dc.b $33 ; ..##..##
                        dc.b $21 ; 
                        dc.b $cc ; ##..##..
                        dc.b $22 ; 
                        dc.b $66 ; .##..##.
                        dc.b $23 ; 
                        dc.b $33 ; ..##..##
                        dc.b $24 ; 
                        dc.b $cc ; ##..##..
                        dc.b $25 ; 
                        dc.b $66 ; .##..##.
                        dc.b $26 ; 
                        dc.b $33 ; ..##..##
                        dc.b $27 ; 
                        dc.b $fc ; ######..
                        dc.b $28 ; 
                        dc.b $7e ; .######.
                        dc.b $29 ; 
                        dc.b $3f ; ..######
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Beach_0e         dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $00 ;          ; ##......................
                        dc.b $c0 ; ##...... ; ##......................
                        dc.b $03 ;          ; ##......................
                        dc.b $c0 ; ##...... ; ##......................
                        dc.b $06 ;          ; ##......................
                        dc.b $c0 ; ##...... ; ....######..............
                        dc.b $09 ;          ; ....##..##..............
                        dc.b $c0 ; ##...... ; ....##..##..............
                        dc.b $0c ;          ; ....##..##..............
                        dc.b $c0 ; ##...... ; ....######..............
                        dc.b $0f ;          ; ...........######.......
                        dc.b $0f ; ....#### ; ...........##..##.......
                        dc.b $10 ;          ; ...........##..##.......
                        dc.b $c0 ; ##...... ; ...........##..##.......
                        dc.b $12 ;          ; ...........######.......
                        dc.b $0c ; ....##.. ; ..................######
                        dc.b $13 ;          ; ..................##..##
                        dc.b $c0 ; ##...... ; ..................##..##
                        dc.b $15 ;          ; ..................##..##
                        dc.b $0c ; ....##.. ; ..................######
                        dc.b $16 ; 
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $0c ; ....##..
                        dc.b $19 ; 
                        dc.b $c0 ; ##......
                        dc.b $1b ; 
                        dc.b $0f ; ....####
                        dc.b $1c ; 
                        dc.b $c0 ; ##......
                        dc.b $1f ; 
                        dc.b $1f ; ...#####
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $19 ; ...##..#
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $25 ; 
                        dc.b $19 ; ...##..#
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $19 ; ...##..#
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $1f ; ...#####
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2f ; 
                        dc.b $3f ; ..######
                        dc.b $32 ; 
                        dc.b $33 ; ..##..##
                        dc.b $35 ; 
                        dc.b $33 ; ..##..##
                        dc.b $38 ; 
                        dc.b $33 ; ..##..##
                        dc.b $3b ; 
                        dc.b $3f ; ..######
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_01          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $0d ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $10 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $13 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $16 ;          ; .........#.##.#.........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $19 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $1c ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $1f ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $22 ;          ; ..........####..........
                        dc.b $5a ; .#.##.#. ; ..........####..........
                        dc.b $25 ; 
                        dc.b $3c ; ..####..
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_02          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0d ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $10 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $13 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $16 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........#.##.#.........
                        dc.b $19 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $1c ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $1f ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $22 ;          ; ..........####..........
                        dc.b $5a ; .#.##.#. ; ..........####..........
                        dc.b $25 ;          ; ..........####..........
                        dc.b $3c ; ..####..
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_03          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $13 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $16 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $19 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........#.##.#.........
                        dc.b $1c ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $1f ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $22 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $25 ;          ; ..........####..........
                        dc.b $5a ; .#.##.#. ; ..........####..........
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_04          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $16 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $19 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $1c ;          ; .........#.##.#.........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $1f ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $22 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $25 ;          ; ..........####..........
                        dc.b $5a ; .#.##.#. ; ..........####..........
                        dc.b $28 ;          ; ..........####..........
                        dc.b $3c ; ..####..
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_05          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $16 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $19 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $1c ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $1f ;          ; .........#.##.#.........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $22 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $25 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $28 ;          ; ..........####..........
                        dc.b $5a ; .#.##.#. ; ..........####..........
                        dc.b $2b ; 
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_06          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $1c ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $1f ;          ; .........######.........
                        dc.b $7e ; .######. ; .........#.##.#.........
                        dc.b $22 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $25 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $28 ;          ; ..........####..........
                        dc.b $5a ; .#.##.#. ; ..........####..........
                        dc.b $2b ;          ; ..........####..........
                        dc.b $3c ; ..####..
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_07          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1c ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $1f ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $22 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........#.##.#.........
                        dc.b $25 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $28 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $2b ;          ; ..........####..........
                        dc.b $5a ; .#.##.#. ; ..........####..........
                        dc.b $2e ; 
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_08          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1f ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $22 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $25 ;          ; .........#.##.#.........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $28 ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $2b ;          ; ..........####..........
                        dc.b $5a ; .#.##.#. ; ..........####..........
                        dc.b $2e ;          ; ..........####..........
                        dc.b $3c ; ..####..
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_09          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $22 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $25 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $28 ;          ; .........#.##.#.........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $2b ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $2e ;          ; ..........####..........
                        dc.b $5a ; .#.##.#. ; ..........####..........
                        dc.b $31 ; 
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_0a          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $25 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $28 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........#.##.#.........
                        dc.b $2b ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $2e ;          ; ..........####..........
                        dc.b $5a ; .#.##.#. ; ..........####..........
                        dc.b $31 ;          ; ..........####..........
                        dc.b $3c ; ..####..
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_0b          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $28 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $2b ;          ; .........######.........
                        dc.b $7e ; .######. ; .........#.##.#.........
                        dc.b $2e ;          ; ..........####..........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $31 ;          ; ..........####..........
                        dc.b $5a ; .#.##.#. ; ..........####..........
                        dc.b $34 ; 
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_0c          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $2b ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $2e ;          ; .........#.##.#.........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $31 ;          ; ..........####..........
                        dc.b $5a ; .#.##.#. ; ..........####..........
                        dc.b $34 ;          ; ..........####..........
                        dc.b $3c ; ..####..
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_0d          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $2e ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $31 ;          ; .........#.##.#.........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $34 ;          ; ..........####..........
                        dc.b $5a ; .#.##.#. ; ..........####..........
                        dc.b $37 ; 
                        dc.b $3c ; ..####..
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_0e          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $31 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $34 ;          ; .........#.##.#.........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $37 ;          ; ..........####..........
                        dc.b $5a ; .#.##.#.
                        dc.b $3a ; 
                        dc.b $3c ; ..####..
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_0f          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $34 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $37 ;          ; .........#.##.#.........
                        dc.b $7e ; .######. ; ..........####..........
                        dc.b $3a ; 
                        dc.b $5a ; .#.##.#.
                        dc.b $3d ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_10          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $37 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $3a ;          ; .........#.##.#.........
                        dc.b $7e ; .######.
                        dc.b $3d ; 
                        dc.b $5a ; .#.##.#.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_11          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $21 ;          ; ######..................
                        dc.b $fc ; ######.. ; ################........
                        dc.b $24 ;          ; ......##########........
                        dc.b $ff ; ######## ; ..............##........
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $27 ; 
                        dc.b $03 ; ......##
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_12          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1e ;          ; #####...................
                        dc.b $f8 ; #####... ; ##########..............
                        dc.b $21 ;          ; .....###########........
                        dc.b $ff ; ######## ; ..........######........
                        dc.b $22 ;          ; ..............##........
                        dc.b $c0 ; ##......
                        dc.b $24 ; 
                        dc.b $07 ; .....###
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $28 ; 
                        dc.b $3f ; ..######
                        dc.b $2b ; 
                        dc.b $03 ; ......##
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_13          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1b ;          ; .####...................
                        dc.b $78 ; .####... ; .########...............
                        dc.b $1e ;          ; .....########...........
                        dc.b $7f ; .####### ; .........########.......
                        dc.b $1f ;          ; .............####.......
                        dc.b $80 ; #....... ; ...............##.......
                        dc.b $21 ; 
                        dc.b $07 ; .....###
                        dc.b $22 ; 
                        dc.b $f8 ; #####...
                        dc.b $25 ; 
                        dc.b $7f ; .#######
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $07 ; .....###
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $01 ; .......#
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_14          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ;          ; ..###...................
                        dc.b $38 ; ..###... ; ..#######...............
                        dc.b $1b ;          ; .....########...........
                        dc.b $3f ; ..###### ; .........########.......
                        dc.b $1c ;          ; .............####.......
                        dc.b $80 ; #....... ; ...............##.......
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $f8 ; #####...
                        dc.b $22 ; 
                        dc.b $7f ; .#######
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $25 ; 
                        dc.b $07 ; .....###
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $01 ; .......#
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_15          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $15 ;          ; ....##..................
                        dc.b $0c ; ....##.. ; ....#####...............
                        dc.b $18 ;          ; ......######............
                        dc.b $0f ; ....#### ; .........######.........
                        dc.b $19 ;          ; ............######......
                        dc.b $80 ; #....... ; ...............###......
                        dc.b $1b ;          ; ................##......
                        dc.b $03 ; ......##
                        dc.b $1c ; 
                        dc.b $f0 ; ####....
                        dc.b $1f ; 
                        dc.b $7e ; .######.
                        dc.b $22 ; 
                        dc.b $0f ; ....####
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $01 ; .......#
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_16          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $12 ;          ; ......##................
                        dc.b $03 ; ......## ; ......####..............
                        dc.b $15 ;          ; .......#####............
                        dc.b $03 ; ......## ; .........#####..........
                        dc.b $16 ;          ; ...........#####........
                        dc.b $c0 ; ##...... ; .............#####......
                        dc.b $18 ;          ; ...............###......
                        dc.b $01 ; .......# ; ................##......
                        dc.b $19 ; 
                        dc.b $f0 ; ####....
                        dc.b $1c ; 
                        dc.b $7c ; .#####..
                        dc.b $1f ; 
                        dc.b $1f ; ...#####
                        dc.b $22 ; 
                        dc.b $07 ; .....###
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $01 ; .......#
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_17          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ;          ; ........##..............
                        dc.b $c0 ; ##...... ; ........###.............
                        dc.b $13 ;          ; .........####...........
                        dc.b $e0 ; ###..... ; ..........####..........
                        dc.b $16 ;          ; ............####........
                        dc.b $78 ; .####... ; .............####.......
                        dc.b $19 ;          ; ..............#####.....
                        dc.b $3c ; ..####.. ; ................###.....
                        dc.b $1c ;          ; .................##.....
                        dc.b $0f ; ....####
                        dc.b $1f ; 
                        dc.b $07 ; .....###
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $03 ; ......##
                        dc.b $23 ; 
                        dc.b $e0 ; ###.....
                        dc.b $26 ; 
                        dc.b $e0 ; ###.....
                        dc.b $29 ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_18          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0d ;          ; ..........##............
                        dc.b $30 ; ..##.... ; ..........###...........
                        dc.b $10 ;          ; ...........###..........
                        dc.b $38 ; ..###... ; ............###.........
                        dc.b $13 ;          ; .............###........
                        dc.b $1c ; ...###.. ; ..............###.......
                        dc.b $16 ;          ; ...............####.....
                        dc.b $0e ; ....###. ; ................###.....
                        dc.b $19 ;          ; .................##.....
                        dc.b $07 ; .....###
                        dc.b $1c ; 
                        dc.b $03 ; ......##
                        dc.b $1d ; 
                        dc.b $80 ; #.......
                        dc.b $1f ; 
                        dc.b $01 ; .......#
                        dc.b $20 ; 
                        dc.b $e0 ; ###.....
                        dc.b $23 ; 
                        dc.b $e0 ; ###.....
                        dc.b $26 ; 
                        dc.b $60 ; .##.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_19          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ;          ; ............##..........
                        dc.b $0c ; ....##.. ; ............###.........
                        dc.b $0d ;          ; .............###........
                        dc.b $0e ; ....###. ; ..............##........
                        dc.b $10 ;          ; ..............###.......
                        dc.b $07 ; .....### ; ...............###......
                        dc.b $13 ;          ; ................###.....
                        dc.b $03 ; ......## ; .................###....
                        dc.b $16 ;          ; .................###....
                        dc.b $03 ; ......## ; ..................##....
                        dc.b $17 ; 
                        dc.b $80 ; #.......
                        dc.b $19 ; 
                        dc.b $01 ; .......#
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1d ; 
                        dc.b $e0 ; ###.....
                        dc.b $20 ; 
                        dc.b $70 ; .###....
                        dc.b $23 ; 
                        dc.b $70 ; .###....
                        dc.b $26 ; 
                        dc.b $30 ; ..##....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_1a          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $07 ;          ; ..............##........
                        dc.b $03 ; ......## ; ..............##........
                        dc.b $0a ;          ; ...............##.......
                        dc.b $03 ; ......## ; ...............##.......
                        dc.b $0d ;          ; ................##......
                        dc.b $01 ; .......# ; .................##.....
                        dc.b $0e ;          ; .................##.....
                        dc.b $80 ; #....... ; ..................##....
                        dc.b $10 ;          ; ..................###...
                        dc.b $01 ; .......# ; ...................##...
                        dc.b $11 ;          ; ...................##...
                        dc.b $80 ; #.......
                        dc.b $14 ; 
                        dc.b $c0 ; ##......
                        dc.b $17 ; 
                        dc.b $60 ; .##.....
                        dc.b $1a ; 
                        dc.b $60 ; .##.....
                        dc.b $1d ; 
                        dc.b $30 ; ..##....
                        dc.b $20 ; 
                        dc.b $38 ; ..###...
                        dc.b $23 ; 
                        dc.b $18 ; ...##...
                        dc.b $26 ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_1b          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $08 ;          ; .................##.....
                        dc.b $60 ; .##..... ; .................##.....
                        dc.b $0b ;          ; .................###....
                        dc.b $60 ; .##..... ; ..................##....
                        dc.b $0e ;          ; ..................##....
                        dc.b $70 ; .###.... ; ...................##...
                        dc.b $11 ;          ; ...................##...
                        dc.b $30 ; ..##.... ; ...................##...
                        dc.b $14 ;          ; ....................##..
                        dc.b $30 ; ..##.... ; ....................##..
                        dc.b $17 ;          ; ....................##..
                        dc.b $18 ; ...##...
                        dc.b $1a ; 
                        dc.b $18 ; ...##...
                        dc.b $1d ; 
                        dc.b $18 ; ...##...
                        dc.b $20 ; 
                        dc.b $0c ; ....##..
                        dc.b $23 ; 
                        dc.b $0c ; ....##..
                        dc.b $26 ; 
                        dc.b $0c ; ....##..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_1c          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $05 ;          ; ...................##...
                        dc.b $18 ; ...##... ; ...................##...
                        dc.b $08 ;          ; ...................##...
                        dc.b $18 ; ...##... ; ...................##...
                        dc.b $0b ;          ; ....................##..
                        dc.b $18 ; ...##... ; ....................##..
                        dc.b $0e ;          ; ....................##..
                        dc.b $18 ; ...##... ; ....................##..
                        dc.b $11 ;          ; .....................##.
                        dc.b $0c ; ....##.. ; .....................##.
                        dc.b $14 ;          ; .....................##.
                        dc.b $0c ; ....##.. ; .....................##.
                        dc.b $17 ; 
                        dc.b $0c ; ....##..
                        dc.b $1a ; 
                        dc.b $0c ; ....##..
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_1d          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $05 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $08 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $0b ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $0e ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $11 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $14 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $17 ; 
                        dc.b $06 ; .....##.
                        dc.b $1a ; 
                        dc.b $06 ; .....##.
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_1e          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $08 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $0b ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $0e ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $11 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $14 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $17 ;          ; .....................##.
                        dc.b $06 ; .....##.
                        dc.b $1a ; 
                        dc.b $06 ; .....##.
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_1f          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0b ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $0e ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $11 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $14 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $17 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $1a ; 
                        dc.b $06 ; .....##.
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_20          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0e ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $11 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $14 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $17 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $1a ;          ; .....................##.
                        dc.b $06 ; .....##.
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_21          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $11 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $14 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $17 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $1a ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $1d ; 
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_22          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $14 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $17 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $1a ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $1d ;          ; .....................##.
                        dc.b $06 ; .....##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_23          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $17 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $1a ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $1d ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $20 ; 
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_24          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1a ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $1d ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $20 ;          ; .....................##.
                        dc.b $06 ; .....##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_25          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1d ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $20 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $23 ; 
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_26          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $20 ;          ; .....................##.
                        dc.b $06 ; .....##. ; .....................##.
                        dc.b $23 ;          ; .....................##.
                        dc.b $06 ; .....##.
                        dc.b $26 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_27          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $1c ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $1f ;          ; .........######.........
                        dc.b $7e ; .######.
                        dc.b $22 ; 
                        dc.b $7e ; .######.
                        dc.b $25 ; 
                        dc.b $7e ; .######.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_28          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0d ;          ; ............##..........
                        dc.b $0c ; ....##.. ; .........######.........
                        dc.b $10 ;          ; ......##..######..##....
                        dc.b $7e ; .######. ; .......############.....
                        dc.b $12 ;          ; .......###########......
                        dc.b $03 ; ......## ; ....###############.....
                        dc.b $13 ;          ; ....################....
                        dc.b $3f ; ..###### ; ......###########.......
                        dc.b $14 ;          ; ........##########......
                        dc.b $30 ; ..##.... ; .......#########........
                        dc.b $15 ;          ; ........###..####.......
                        dc.b $01 ; .......# ; ........##..###.........
                        dc.b $16 ;          ; .............##.........
                        dc.b $ff ; ########
                        dc.b $17 ; 
                        dc.b $e0 ; ###.....
                        dc.b $18 ; 
                        dc.b $01 ; .......#
                        dc.b $19 ; 
                        dc.b $ff ; ########
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1b ; 
                        dc.b $0f ; ....####
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $0f ; ....####
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $f0 ; ####....
                        dc.b $21 ; 
                        dc.b $03 ; ......##
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $2b ; 
                        dc.b $e7 ; ###..###
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $ce ; ##..###.
                        dc.b $31 ; 
                        dc.b $06 ; .....##.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_29          dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $40, $00  ; .........#..............
                        dc.b $00, $60, $00  ; .........##.............
                        dc.b $00, $60, $c0  ; .........##.....##......
                        dc.b $11, $db, $98  ; ...#...###.##.###..##...
                        dc.b $39, $bf, $7c  ; ..###..##.######.#####..
                        dc.b $1f, $f9, $d8  ; ...##########..###.##...
                        dc.b $06, $7f, $f0  ; .....##..###########....
                        dc.b $1f, $df, $78  ; ...#######.#####.####...
                        dc.b $7b, $f7, $f0  ; .####.######.#######....
                        dc.b $0e, $fe, $fe  ; ....###.#######.#######.
                        dc.b $0f, $ff, $9c  ; ....#############..###..
                        dc.b $3b, $ff, $f8  ; ..###.###############...
                        dc.b $07, $ff, $ef  ; .....##############.####
                        dc.b $1f, $ff, $fc  ; ...###################..
                        dc.b $7f, $ff, $f0  ; .###################....
                        dc.b $3f, $ff, $f8  ; ..###################...
                        dc.b $ff, $ff, $fe  ; #######################.
                        dc.b $7f, $ff, $fe  ; .######################.
                        dc.b $ff, $ff, $ff  ; ########################
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_2a          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ............#.#.........
                        dc.b $0a ; ....#.#. ; ..........#.#.#.#.......
                        dc.b $1c ;          ; ..........#.#.#.........
                        dc.b $2a ; ..#.#.#. ; ........#.#.#...........
                        dc.b $1d ;          ; ........#.#.#.#.........
                        dc.b $80 ; #....... ; ........#.#.#.#.#.......
                        dc.b $1f ;          ; ........#.#.####........
                        dc.b $2a ; ..#.#.#.
                        dc.b $22 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $af ; #.#.####
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_2b          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ........#...#...........
                        dc.b $88 ; #...#... ; ........#...#.##........
                        dc.b $1c ;          ; ........#.#.#.##........
                        dc.b $8b ; #...#.## ; ........#.#.#.##........
                        dc.b $1f ;          ; ..........#.#.#.........
                        dc.b $ab ; #.#.#.## ; ..........#.#.#.........
                        dc.b $22 ;          ; ............#.#.........
                        dc.b $ab ; #.#.#.## ; ............#.#.........
                        dc.b $25 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $28 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $2b ; 
                        dc.b $0a ; ....#.#.
                        dc.b $2e ; 
                        dc.b $0a ; ....#.#.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_2c          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ........#####.#.........
                        dc.b $fa ; #####.#. ; ......#.#.#.#.#.........
                        dc.b $1b ;          ; ........#.#.#.#.........
                        dc.b $02 ; ......#. ; ..........#.#.#.........
                        dc.b $1c ;          ; ........#.#.#...........
                        dc.b $aa ; #.#.#.#. ; ......#.#.#.#...........
                        dc.b $1f ;          ; ........#.#.............
                        dc.b $aa ; #.#.#.#.
                        dc.b $22 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $25 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $27 ; 
                        dc.b $02 ; ......#.
                        dc.b $28 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $2b ; 
                        dc.b $a0 ; #.#.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_2d          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ........#.#.............
                        dc.b $a0 ; #.#..... ; ........#.#.............
                        dc.b $1c ;          ; ........#.#.#...........
                        dc.b $a0 ; #.#..... ; ........#.#.#...........
                        dc.b $1f ;          ; ........###.#.#.........
                        dc.b $a8 ; #.#.#... ; ........###.#.#.........
                        dc.b $22 ;          ; ........###...#.........
                        dc.b $a8 ; #.#.#... ; ..........#...#.........
                        dc.b $25 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $28 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $2b ; 
                        dc.b $e2 ; ###...#.
                        dc.b $2e ; 
                        dc.b $22 ; ..#...#.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_2e          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ........#.#.#.#.........
                        dc.b $aa ; #.#.#.#. ; ........#.#.#.#.........
                        dc.b $1c ;          ; ......#.#.#.#.#.#.......
                        dc.b $aa ; #.#.#.#. ; ........#.#.#.#.........
                        dc.b $1e ;          ; ..........#.#...........
                        dc.b $02 ; ......#. ; ........#.#.#.#.........
                        dc.b $1f ;          ; ......#.#.#.#.#.#.......
                        dc.b $aa ; #.#.#.#. ; ........###.#.##........
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $25 ; 
                        dc.b $28 ; ..#.#...
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2a ; 
                        dc.b $02 ; ......#.
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $eb ; ###.#.##
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_2f          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ........#...#...........
                        dc.b $88 ; #...#... ; ......#.#...#.##........
                        dc.b $1b ;          ; ......#.#.#.#.##........
                        dc.b $02 ; ......#. ; ......#.#.#.#.#.........
                        dc.b $1c ;          ; ......#.#.#.#.#.........
                        dc.b $8b ; #...#.## ; ......#.#.#.#.##........
                        dc.b $1e ;          ; ......#.#...#.##........
                        dc.b $02 ; ......#. ; ........#...#...........
                        dc.b $1f ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $21 ; 
                        dc.b $02 ; ......#.
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $24 ; 
                        dc.b $02 ; ......#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $27 ; 
                        dc.b $02 ; ......#.
                        dc.b $28 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $2a ; 
                        dc.b $02 ; ......#.
                        dc.b $2b ; 
                        dc.b $8b ; #...#.##
                        dc.b $2e ; 
                        dc.b $88 ; #...#...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_30          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ........###.#.##........
                        dc.b $eb ; ###.#.## ; ......#.#.#.#.#.#.......
                        dc.b $1b ;          ; ........#.#.#.#.........
                        dc.b $02 ; ......#. ; ..........#.#...........
                        dc.b $1c ;          ; ........#.#.#.#.........
                        dc.b $aa ; #.#.#.#. ; ......#.#.#.#.#.#.......
                        dc.b $1d ;          ; ........#.#.#.#.........
                        dc.b $80 ; #....... ; ........#.#.#.#.........
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $22 ; 
                        dc.b $28 ; ..#.#...
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $27 ; 
                        dc.b $02 ; ......#.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2e ; 
                        dc.b $aa ; #.#.#.#.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_31          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ........#...#...........
                        dc.b $88 ; #...#... ; ......###...#.#.........
                        dc.b $1b ;          ; ......###.#.#.#.........
                        dc.b $03 ; ......## ; ......#.#.#.#.#.........
                        dc.b $1c ;          ; ......#.#.#.#.#.........
                        dc.b $8a ; #...#.#. ; ......###.#.#.#.........
                        dc.b $1e ;          ; ......###...#.#.........
                        dc.b $03 ; ......## ; ........#...#...........
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $21 ; 
                        dc.b $02 ; ......#.
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $24 ; 
                        dc.b $02 ; ......#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $27 ; 
                        dc.b $03 ; ......##
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2a ; 
                        dc.b $03 ; ......##
                        dc.b $2b ; 
                        dc.b $8a ; #...#.#.
                        dc.b $2e ; 
                        dc.b $88 ; #...#...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_32          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ........#...............
                        dc.b $80 ; #....... ; ........#.#.#...........
                        dc.b $1c ;          ; ......#.#.#.#.#.........
                        dc.b $a8 ; #.#.#... ; ........#.#.#.#.#.......
                        dc.b $1e ;          ; ..........#.#.#.#.......
                        dc.b $02 ; ......#. ; ........#.#.#.#.#.......
                        dc.b $1f ;          ; ......#.#.#.#.#.#.......
                        dc.b $aa ; #.#.#.#. ; ........#######.#.......
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $25 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2a ; 
                        dc.b $02 ; ......#.
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $fe ; #######.
                        dc.b $2f ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_33          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ..........#...#.........
                        dc.b $22 ; ..#...#. ; ........###.#.#.#.......
                        dc.b $1c ;          ; ........###.#.#.#.......
                        dc.b $ea ; ###.#.#. ; ........###.#.#.........
                        dc.b $1d ;          ; ........###.#.#.........
                        dc.b $80 ; #....... ; ........###.#.#.........
                        dc.b $1f ;          ; ........#.#.#...........
                        dc.b $ea ; ###.#.#. ; ........#.#.#...........
                        dc.b $20 ;          ; ........#.#.............
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $25 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $28 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $2b ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $2e ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $31 ; 
                        dc.b $a0 ; #.#.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_34          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ;          ; ......#.#.######........
                        dc.b $02 ; ......#. ; ......#.#.#.#.#.#.......
                        dc.b $19 ;          ; ......#.#.#.#.#.........
                        dc.b $bf ; #.###### ; ......#.#.#.#...........
                        dc.b $1b ;          ; ........#.#.#.#.........
                        dc.b $02 ; ......#. ; ........#.#.#.#.#.......
                        dc.b $1c ;          ; ..........#.#.#.........
                        dc.b $aa ; #.#.#.#. ; ..............#.........
                        dc.b $1d ; 
                        dc.b $80 ; #.......
                        dc.b $1e ; 
                        dc.b $02 ; ......#.
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $21 ; 
                        dc.b $02 ; ......#.
                        dc.b $22 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $2e ; 
                        dc.b $02 ; ......#.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_35          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ..............#.#.......
                        dc.b $02 ; ......#. ; ............#.#.#.......
                        dc.b $1a ;          ; ............#.#.#.......
                        dc.b $80 ; #....... ; ..........#.#.#.##......
                        dc.b $1c ;          ; ..........#.#.#.##......
                        dc.b $0a ; ....#.#. ; ..........#.#.#.##......
                        dc.b $1d ;          ; ........#.#.#.#.##......
                        dc.b $80 ; #....... ; ........#.#...#.##......
                        dc.b $1f ;          ; ..........#...#.........
                        dc.b $0a ; ....#.#.
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $28 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2c ; 
                        dc.b $c0 ; ##......
                        dc.b $2e ; 
                        dc.b $a2 ; #.#...#.
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        dc.b $31 ; 
                        dc.b $22 ; ..#...#.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_36          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ;          ; ......#######.#.#.#.....
                        dc.b $03 ; ......## ; ....#.#.#.#.#.#.#.#.#...
                        dc.b $19 ;          ; ..#.#.#.#.#.#.#.#.#.....
                        dc.b $fa ; #####.#. ; ..#.#.#.#.#.#.#.#.......
                        dc.b $1a ;          ; ..#.#.#.#.#.#.#.#.#.....
                        dc.b $a0 ; #.#..... ; ..#.#.#.#.#.#.#.######..
                        dc.b $1b ;          ; ..#.#.#.#.#.########....
                        dc.b $0a ; ....#.#. ; ..#.################....
                        dc.b $1c ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $1d ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $1e ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $20 ; 
                        dc.b $a0 ; #.#.....
                        dc.b $21 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $24 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $a0 ; #.#.....
                        dc.b $27 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $fc ; ######..
                        dc.b $2a ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $2b ; 
                        dc.b $af ; #.#.####
                        dc.b $2c ; 
                        dc.b $f0 ; ####....
                        dc.b $2d ; 
                        dc.b $2f ; ..#.####
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $2f ; 
                        dc.b $f0 ; ####....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_37          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0d ;          ; ..........#...##........
                        dc.b $23 ; ..#...## ; ........#.#...####......
                        dc.b $10 ;          ; ........#.#.#.####......
                        dc.b $a3 ; #.#...## ; ........#.#.#.####......
                        dc.b $11 ;          ; ........#.#.#.####......
                        dc.b $c0 ; ##...... ; ........#.#.#.####......
                        dc.b $13 ;          ; ........#.#.#.####......
                        dc.b $ab ; #.#.#.## ; ........#.#.#.#.##......
                        dc.b $14 ;          ; ........#.#.#.#.##......
                        dc.b $c0 ; ##...... ; ........###.#.#.##......
                        dc.b $16 ;          ; ........###.#.#.##......
                        dc.b $ab ; #.#.#.## ; ........###.#.#.##......
                        dc.b $17 ;          ; ........###.#.#.##......
                        dc.b $c0 ; ##...... ; ..........#.#.#.##......
                        dc.b $19 ;          ; ..........#.#.#.#.......
                        dc.b $ab ; #.#.#.## ; ..........#.#.#.#.......
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1c ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $1d ; 
                        dc.b $c0 ; ##......
                        dc.b $1f ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $20 ; 
                        dc.b $c0 ; ##......
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $28 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2b ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $2c ; 
                        dc.b $c0 ; ##......
                        dc.b $2e ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        dc.b $31 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $32 ; 
                        dc.b $c0 ; ##......
                        dc.b $34 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $35 ; 
                        dc.b $c0 ; ##......
                        dc.b $37 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $38 ; 
                        dc.b $80 ; #.......
                        dc.b $3a ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $3b ; 
                        dc.b $80 ; #.......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_38          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ;          ; ....#################...
                        dc.b $0f ; ....#### ; ....#########.#.#.#.#...
                        dc.b $19 ;          ; ..#######.#.#.#.#.#.#...
                        dc.b $ff ; ######## ; ....#.#.#.#.#.#.#.#.#...
                        dc.b $1a ;          ; ......#.#.#.#.#.#.#.#...
                        dc.b $f8 ; #####... ; ....#.#.#.#.#.#.#.#.#...
                        dc.b $1b ;          ; ..#.#.#.#.#.#.#.#.#.....
                        dc.b $0f ; ....#### ; ....#.#.#.#.######......
                        dc.b $1c ; 
                        dc.b $fa ; #####.#.
                        dc.b $1d ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $1e ; 
                        dc.b $3f ; ..######
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $20 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $21 ; 
                        dc.b $0a ; ....#.#.
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $24 ; 
                        dc.b $02 ; ......#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $27 ; 
                        dc.b $0a ; ....#.#.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $2a ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2c ; 
                        dc.b $a0 ; #.#.....
                        dc.b $2d ; 
                        dc.b $0a ; ....#.#.
                        dc.b $2e ; 
                        dc.b $af ; #.#.####
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_39          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ;          ; ........#.#.#.#.........
                        dc.b $aa ; #.#.#.#. ; ........#.#.#.#.........
                        dc.b $13 ;          ; ........###.#.#.........
                        dc.b $aa ; #.#.#.#. ; ........###.#.#.##......
                        dc.b $16 ;          ; ........###.#.#.##......
                        dc.b $ea ; ###.#.#. ; ........###.#.#.##......
                        dc.b $19 ;          ; ........###.#.#.##......
                        dc.b $ea ; ###.#.#. ; ........###.#.#.#.......
                        dc.b $1a ;          ; ........#####.#.#.......
                        dc.b $c0 ; ##...... ; ........#####.#.#.......
                        dc.b $1c ;          ; ........#####.#.#.......
                        dc.b $ea ; ###.#.#. ; ........#####.#.#.......
                        dc.b $1d ;          ; ........#####.#.#.......
                        dc.b $c0 ; ##...... ; ........####..#.#.......
                        dc.b $1f ;          ; ..........##..#.........
                        dc.b $ea ; ###.#.#.
                        dc.b $20 ; 
                        dc.b $c0 ; ##......
                        dc.b $22 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $fa ; #####.#.
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $fa ; #####.#.
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $fa ; #####.#.
                        dc.b $2f ; 
                        dc.b $80 ; #.......
                        dc.b $31 ; 
                        dc.b $fa ; #####.#.
                        dc.b $32 ; 
                        dc.b $80 ; #.......
                        dc.b $34 ; 
                        dc.b $fa ; #####.#.
                        dc.b $35 ; 
                        dc.b $80 ; #.......
                        dc.b $37 ; 
                        dc.b $f2 ; ####..#.
                        dc.b $38 ; 
                        dc.b $80 ; #.......
                        dc.b $3a ; 
                        dc.b $32 ; ..##..#.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_3a          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ;          ; ....#.#.#.#.#.####......
                        dc.b $0a ; ....#.#. ; ......#.#.#.#.#.#.#.....
                        dc.b $19 ;          ; ....#.#.#.#.#.#.#.#.#...
                        dc.b $ab ; #.#.#.## ; ..#.#.#.#.#.#.#.#.#.#.#.
                        dc.b $1a ;          ; ....#.#.#.#.#.#.#.#.#.#.
                        dc.b $c0 ; ##...... ; ......#####.#.#.#.#.#.#.
                        dc.b $1b ;          ; ....###########.#.#.#.#.
                        dc.b $02 ; ......#. ; ....###################.
                        dc.b $1c ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $1d ; 
                        dc.b $a0 ; #.#.....
                        dc.b $1e ; 
                        dc.b $0a ; ....#.#.
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $20 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $21 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $24 ; 
                        dc.b $0a ; ....#.#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $27 ; 
                        dc.b $03 ; ......##
                        dc.b $28 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $29 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2a ; 
                        dc.b $0f ; ....####
                        dc.b $2b ; 
                        dc.b $fe ; #######.
                        dc.b $2c ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2d ; 
                        dc.b $0f ; ....####
                        dc.b $2e ; 
                        dc.b $ff ; ########
                        dc.b $2f ; 
                        dc.b $fe ; #######.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_3b          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0d ;          ; ............#...........
                        dc.b $08 ; ....#... ; ........##..#...#.......
                        dc.b $10 ;          ; ........#####.#.#.......
                        dc.b $c8 ; ##..#... ; ........#####.#.#.......
                        dc.b $11 ;          ; ........#####.#.#.......
                        dc.b $80 ; #....... ; ........#####.#.#.......
                        dc.b $13 ;          ; ........#####.#.#.......
                        dc.b $fa ; #####.#. ; ........#####.#.#.......
                        dc.b $14 ;          ; ........###.#.#.#.......
                        dc.b $80 ; #....... ; ........###.#.#.##......
                        dc.b $16 ;          ; ........###.#.#.##......
                        dc.b $fa ; #####.#. ; ........###.#.#.##......
                        dc.b $17 ;          ; ........###.#.#.........
                        dc.b $80 ; #....... ; ........###.#.#.........
                        dc.b $19 ;          ; ........#.#.#...........
                        dc.b $fa ; #####.#. ; ........#.#.#...........
                        dc.b $1a ; 
                        dc.b $80 ; #.......
                        dc.b $1c ; 
                        dc.b $fa ; #####.#.
                        dc.b $1d ; 
                        dc.b $80 ; #.......
                        dc.b $1f ; 
                        dc.b $fa ; #####.#.
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $fa ; #####.#.
                        dc.b $23 ; 
                        dc.b $80 ; #.......
                        dc.b $25 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $26 ; 
                        dc.b $80 ; #.......
                        dc.b $28 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2b ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $2c ; 
                        dc.b $c0 ; ##......
                        dc.b $2e ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        dc.b $31 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $34 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $37 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $3a ; 
                        dc.b $a8 ; #.#.#...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_3c          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $18 ;          ; ..#.##################..
                        dc.b $2f ; ..#.#### ; ..#.#.#.#.#.##########..
                        dc.b $19 ;          ; ..#.#.#.#.#.#.#.####....
                        dc.b $ff ; ######## ; ..#.#.#.#.#.#.#.#.#.#...
                        dc.b $1a ;          ; ..#.#.#.#.#.#.#.#.#.#.#.
                        dc.b $fc ; ######.. ; ....#.#.#.#.#.#.#.#.#...
                        dc.b $1b ;          ; ......#.#.#.#.#.#.#.....
                        dc.b $2a ; ..#.#.#. ; ........#####.#.#.#.#...
                        dc.b $1c ; 
                        dc.b $af ; #.#.####
                        dc.b $1d ; 
                        dc.b $fc ; ######..
                        dc.b $1e ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $1f ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $20 ; 
                        dc.b $f0 ; ####....
                        dc.b $21 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $24 ; 
                        dc.b $2a ; ..#.#.#.
                        dc.b $25 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $26 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $27 ; 
                        dc.b $0a ; ....#.#.
                        dc.b $28 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $29 ; 
                        dc.b $a8 ; #.#.#...
                        dc.b $2a ; 
                        dc.b $02 ; ......#.
                        dc.b $2b ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $2c ; 
                        dc.b $a0 ; #.#.....
                        dc.b $2e ; 
                        dc.b $fa ; #####.#.
                        dc.b $2f ; 
                        dc.b $a8 ; #.#.#...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_3d          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0d ;          ; ............#.#.#.......
                        dc.b $0a ; ....#.#. ; ............#.#.#.......
                        dc.b $0e ;          ; ..........#.#.#.##......
                        dc.b $80 ; #....... ; ..........#.#.#.##......
                        dc.b $10 ;          ; ........###.#.#.##......
                        dc.b $0a ; ....#.#. ; ........###.#.#.##......
                        dc.b $11 ;          ; ........###.#.#.##......
                        dc.b $80 ; #....... ; ........#.#.#.#.##......
                        dc.b $13 ;          ; ........#.#.#.####......
                        dc.b $2a ; ..#.#.#. ; ........#.#.#.####......
                        dc.b $14 ;          ; ........#.#.#.####......
                        dc.b $c0 ; ##...... ; ........#.#.#.####......
                        dc.b $16 ;          ; ........#.#.#.####......
                        dc.b $2a ; ..#.#.#. ; ........#.#.#.####......
                        dc.b $17 ;          ; ........#...#...##......
                        dc.b $c0 ; ##...... ; ............#...........
                        dc.b $19 ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1c ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $1d ; 
                        dc.b $c0 ; ##......
                        dc.b $1f ; 
                        dc.b $ea ; ###.#.#.
                        dc.b $20 ; 
                        dc.b $c0 ; ##......
                        dc.b $22 ; 
                        dc.b $aa ; #.#.#.#.
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $25 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $28 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2b ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $2c ; 
                        dc.b $c0 ; ##......
                        dc.b $2e ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $2f ; 
                        dc.b $c0 ; ##......
                        dc.b $31 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $32 ; 
                        dc.b $c0 ; ##......
                        dc.b $34 ; 
                        dc.b $ab ; #.#.#.##
                        dc.b $35 ; 
                        dc.b $c0 ; ##......
                        dc.b $37 ; 
                        dc.b $88 ; #...#...
                        dc.b $38 ; 
                        dc.b $c0 ; ##......
                        dc.b $3a ; 
                        dc.b $08 ; ....#...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_3e          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0f ;          ; .....##.................
                        dc.b $06 ; .....##. ; ...####.................
                        dc.b $12 ;          ; .#######................
                        dc.b $1e ; ...####. ; ########................
                        dc.b $15 ;          ; ######..#...............
                        dc.b $7f ; .####### ; .###....#...............
                        dc.b $18 ;          ; .#.......#..............
                        dc.b $ff ; ######## ; .........#..............
                        dc.b $1b ;          ; .........##.............
                        dc.b $fc ; ######.. ; ..........##............
                        dc.b $1c ;          ; ...........#............
                        dc.b $80 ; #.......
                        dc.b $1e ; 
                        dc.b $70 ; .###....
                        dc.b $1f ; 
                        dc.b $80 ; #.......
                        dc.b $21 ; 
                        dc.b $40 ; .#......
                        dc.b $22 ; 
                        dc.b $40 ; .#......
                        dc.b $25 ; 
                        dc.b $40 ; .#......
                        dc.b $28 ; 
                        dc.b $60 ; .##.....
                        dc.b $2b ; 
                        dc.b $30 ; ..##....
                        dc.b $2e ; 
                        dc.b $10 ; ...#....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_3f          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0f ;          ; ....########............
                        dc.b $0f ; ....#### ; ....########............
                        dc.b $10 ;          ; ....########............
                        dc.b $f0 ; ####.... ; ....########............
                        dc.b $12 ;          ; ...........#............
                        dc.b $0f ; ....#### ; ...........#............
                        dc.b $13 ;          ; ...........#............
                        dc.b $f0 ; ####.... ; ...........##...........
                        dc.b $15 ;          ; ...........##...........
                        dc.b $0f ; ....#### ; ............#...........
                        dc.b $16 ;          ; ............#...........
                        dc.b $f0 ; ####....
                        dc.b $18 ; 
                        dc.b $0f ; ....####
                        dc.b $19 ; 
                        dc.b $f0 ; ####....
                        dc.b $1c ; 
                        dc.b $10 ; ...#....
                        dc.b $1f ; 
                        dc.b $10 ; ...#....
                        dc.b $22 ; 
                        dc.b $10 ; ...#....
                        dc.b $25 ; 
                        dc.b $18 ; ...##...
                        dc.b $28 ; 
                        dc.b $18 ; ...##...
                        dc.b $2b ; 
                        dc.b $08 ; ....#...
                        dc.b $2e ; 
                        dc.b $08 ; ....#...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_40          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ;          ; .............##.........
                        dc.b $06 ; .....##. ; ............#####.......
                        dc.b $0d ;          ; ...........########.....
                        dc.b $0f ; ....#### ; ...........##########...
                        dc.b $0e ;          ; .............#######....
                        dc.b $80 ; #....... ; ...............####.....
                        dc.b $10 ;          ; .................#......
                        dc.b $1f ; ...##### ; ................#.......
                        dc.b $11 ;          ; ...............#........
                        dc.b $e0 ; ###..... ; .............##.........
                        dc.b $13 ;          ; .............##.........
                        dc.b $1f ; ...##### ; ............##..........
                        dc.b $14 ;          ; ...........##...........
                        dc.b $f8 ; #####...
                        dc.b $16 ; 
                        dc.b $07 ; .....###
                        dc.b $17 ; 
                        dc.b $f0 ; ####....
                        dc.b $19 ; 
                        dc.b $01 ; .......#
                        dc.b $1a ; 
                        dc.b $e0 ; ###.....
                        dc.b $1d ; 
                        dc.b $40 ; .#......
                        dc.b $20 ; 
                        dc.b $80 ; #.......
                        dc.b $22 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $06 ; .....##.
                        dc.b $28 ; 
                        dc.b $06 ; .....##.
                        dc.b $2b ; 
                        dc.b $0c ; ....##..
                        dc.b $2e ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_41          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $11 ;          ; ................##......
                        dc.b $c0 ; ##...... ; ................####....
                        dc.b $14 ;          ; ...............#######..
                        dc.b $f0 ; ####.... ; ...............########.
                        dc.b $16 ;          ; ..............#..######.
                        dc.b $01 ; .......# ; ..............#....###..
                        dc.b $17 ;          ; .............#.......#..
                        dc.b $fc ; ######.. ; ............##..........
                        dc.b $19 ;          ; ............##..........
                        dc.b $01 ; .......# ; ...........##...........
                        dc.b $1a ;          ; ...........#............
                        dc.b $fe ; #######.
                        dc.b $1c ; 
                        dc.b $02 ; ......#.
                        dc.b $1d ; 
                        dc.b $7e ; .######.
                        dc.b $1f ; 
                        dc.b $02 ; ......#.
                        dc.b $20 ; 
                        dc.b $1c ; ...###..
                        dc.b $22 ; 
                        dc.b $04 ; .....#..
                        dc.b $23 ; 
                        dc.b $04 ; .....#..
                        dc.b $25 ; 
                        dc.b $0c ; ....##..
                        dc.b $28 ; 
                        dc.b $0c ; ....##..
                        dc.b $2b ; 
                        dc.b $18 ; ...##...
                        dc.b $2e ; 
                        dc.b $10 ; ...#....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_42          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ;          ; ...........########.....
                        dc.b $1f ; ...##### ; ...........########.....
                        dc.b $11 ;          ; ...........########.....
                        dc.b $e0 ; ###..... ; ...........########.....
                        dc.b $13 ;          ; ...........#............
                        dc.b $1f ; ...##### ; ...........#............
                        dc.b $14 ;          ; ..........##............
                        dc.b $e0 ; ###..... ; ..........##............
                        dc.b $16 ;          ; ..........#.............
                        dc.b $1f ; ...##### ; ..........#.............
                        dc.b $17 ;          ; ..........#.............
                        dc.b $e0 ; ###.....
                        dc.b $19 ; 
                        dc.b $1f ; ...#####
                        dc.b $1a ; 
                        dc.b $e0 ; ###.....
                        dc.b $1c ; 
                        dc.b $10 ; ...#....
                        dc.b $1f ; 
                        dc.b $10 ; ...#....
                        dc.b $22 ; 
                        dc.b $30 ; ..##....
                        dc.b $25 ; 
                        dc.b $30 ; ..##....
                        dc.b $28 ; 
                        dc.b $20 ; ..#.....
                        dc.b $2b ; 
                        dc.b $20 ; ..#.....
                        dc.b $2e ; 
                        dc.b $20 ; ..#.....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_43          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ;          ; ........##..............
                        dc.b $c0 ; ##...... ; ......#####.............
                        dc.b $0c ;          ; ....########............
                        dc.b $03 ; ......## ; ..##########............
                        dc.b $0d ;          ; ...#######..............
                        dc.b $e0 ; ###..... ; ....####................
                        dc.b $0f ;          ; .....#..................
                        dc.b $0f ; ....#### ; ......#.................
                        dc.b $10 ;          ; .......#................
                        dc.b $f0 ; ####.... ; ........##..............
                        dc.b $12 ;          ; ........###.............
                        dc.b $3f ; ..###### ; ..........##............
                        dc.b $13 ;          ; ...........##...........
                        dc.b $f0 ; ####....
                        dc.b $15 ; 
                        dc.b $1f ; ...#####
                        dc.b $16 ; 
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $0f ; ....####
                        dc.b $1b ; 
                        dc.b $04 ; .....#..
                        dc.b $1e ; 
                        dc.b $02 ; ......#.
                        dc.b $21 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $c0 ; ##......
                        dc.b $28 ; 
                        dc.b $e0 ; ###.....
                        dc.b $2b ; 
                        dc.b $30 ; ..##....
                        dc.b $2e ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_44          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ;          ; ............#...........
                        dc.b $08 ; ....#... ; ............###..#......
                        dc.b $0d ;          ; ........##.########.....
                        dc.b $0e ; ....###. ; ....##.##############...
                        dc.b $0e ;          ; .....#################..
                        dc.b $40 ; .#...... ; ..#..##################.
                        dc.b $10 ;          ; .#####################..
                        dc.b $df ; ##.##### ; .#######################
                        dc.b $11 ;          ; ..#####################.
                        dc.b $e0 ; ###..... ; .#######################
                        dc.b $12 ; 
                        dc.b $0d ; ....##.#
                        dc.b $13 ; 
                        dc.b $ff ; ########
                        dc.b $14 ; 
                        dc.b $f8 ; #####...
                        dc.b $15 ; 
                        dc.b $07 ; .....###
                        dc.b $16 ; 
                        dc.b $ff ; ########
                        dc.b $17 ; 
                        dc.b $fc ; ######..
                        dc.b $18 ; 
                        dc.b $27 ; ..#..###
                        dc.b $19 ; 
                        dc.b $ff ; ########
                        dc.b $1a ; 
                        dc.b $fe ; #######.
                        dc.b $1b ; 
                        dc.b $7f ; .#######
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $fc ; ######..
                        dc.b $1e ; 
                        dc.b $7f ; .#######
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $ff ; ########
                        dc.b $21 ; 
                        dc.b $3f ; ..######
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $fe ; #######.
                        dc.b $24 ; 
                        dc.b $7f ; .#######
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $26 ; 
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_45          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $1c ;          ; ...........##...........
                        dc.b $18 ; ...##... ; ..........####..........
                        dc.b $1f ;          ; ...........##...........
                        dc.b $3c ; ..####..
                        dc.b $22 ; 
                        dc.b $18 ; ...##...
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_46          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $19 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $1c ;          ; .........######.........
                        dc.b $7e ; .######. ; .........######.........
                        dc.b $1f ;          ; ..........####..........
                        dc.b $7e ; .######.
                        dc.b $22 ; 
                        dc.b $7e ; .######.
                        dc.b $25 ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_47          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $16 ;          ; ..........####..........
                        dc.b $3c ; ..####.. ; .........######.........
                        dc.b $19 ;          ; ........########........
                        dc.b $7e ; .######. ; ........########........
                        dc.b $1c ;          ; ........########........
                        dc.b $ff ; ######## ; .........######.........
                        dc.b $1f ;          ; ..........####..........
                        dc.b $ff ; ########
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $25 ; 
                        dc.b $7e ; .######.
                        dc.b $28 ; 
                        dc.b $3c ; ..####..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_48          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $13 ;          ; .........######.........
                        dc.b $7e ; .######. ; .......##########.......
                        dc.b $15 ;          ; ......############......
                        dc.b $01 ; .......# ; ......############......
                        dc.b $16 ;          ; ......############......
                        dc.b $ff ; ######## ; ......############......
                        dc.b $17 ;          ; ......############......
                        dc.b $80 ; #....... ; .......##########.......
                        dc.b $18 ;          ; .........######.........
                        dc.b $03 ; ......##
                        dc.b $19 ; 
                        dc.b $ff ; ########
                        dc.b $1a ; 
                        dc.b $c0 ; ##......
                        dc.b $1b ; 
                        dc.b $03 ; ......##
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $c0 ; ##......
                        dc.b $1e ; 
                        dc.b $03 ; ......##
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $c0 ; ##......
                        dc.b $21 ; 
                        dc.b $03 ; ......##
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $c0 ; ##......
                        dc.b $24 ; 
                        dc.b $03 ; ......##
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $29 ; 
                        dc.b $80 ; #.......
                        dc.b $2b ; 
                        dc.b $7e ; .######.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_49          dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ;          ; .........######.........
                        dc.b $7e ; .######. ; .......##########.......
                        dc.b $12 ;          ; ......############......
                        dc.b $01 ; .......# ; .....##############.....
                        dc.b $13 ;          ; .....##############.....
                        dc.b $ff ; ######## ; .....##############.....
                        dc.b $14 ;          ; .....##############.....
                        dc.b $80 ; #....... ; .....##############.....
                        dc.b $15 ;          ; ......############......
                        dc.b $03 ; ......## ; .......##########.......
                        dc.b $16 ;          ; .........######.........
                        dc.b $ff ; ########
                        dc.b $17 ; 
                        dc.b $c0 ; ##......
                        dc.b $18 ; 
                        dc.b $07 ; .....###
                        dc.b $19 ; 
                        dc.b $ff ; ########
                        dc.b $1a ; 
                        dc.b $e0 ; ###.....
                        dc.b $1b ; 
                        dc.b $07 ; .....###
                        dc.b $1c ; 
                        dc.b $ff ; ########
                        dc.b $1d ; 
                        dc.b $e0 ; ###.....
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $ff ; ########
                        dc.b $20 ; 
                        dc.b $e0 ; ###.....
                        dc.b $21 ; 
                        dc.b $07 ; .....###
                        dc.b $22 ; 
                        dc.b $ff ; ########
                        dc.b $23 ; 
                        dc.b $e0 ; ###.....
                        dc.b $24 ; 
                        dc.b $07 ; .....###
                        dc.b $25 ; 
                        dc.b $ff ; ########
                        dc.b $26 ; 
                        dc.b $e0 ; ###.....
                        dc.b $27 ; 
                        dc.b $03 ; ......##
                        dc.b $28 ; 
                        dc.b $ff ; ########
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2a ; 
                        dc.b $01 ; .......#
                        dc.b $2b ; 
                        dc.b $ff ; ########
                        dc.b $2c ; 
                        dc.b $80 ; #.......
                        dc.b $2e ; 
                        dc.b $7e ; .######.
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_4a          dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $7e, $00  ; .........######.........
                        dc.b $01, $ff, $80  ; .......##########.......
                        dc.b $03, $ff, $c0  ; ......############......
                        dc.b $07, $ff, $e0  ; .....##############.....
                        dc.b $0f, $ff, $f0  ; ....################....
                        dc.b $0f, $ff, $f0  ; ....################....
                        dc.b $0f, $ff, $f0  ; ....################....
                        dc.b $0f, $ff, $f0  ; ....################....
                        dc.b $0f, $ff, $f0  ; ....################....
                        dc.b $07, $ff, $e0  ; .....##############.....
                        dc.b $03, $ff, $c0  ; ......############......
                        dc.b $01, $ff, $80  ; .......##########.......
                        dc.b $00, $7e, $00  ; .........######.........
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_4b          dc.b $00 ; <flag: full sprite data>

                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $ff, $00  ; ........########........
                        dc.b $03, $ff, $c0  ; ......############......
                        dc.b $07, $ff, $e0  ; .....##############.....
                        dc.b $0f, $ff, $f0  ; ....################....
                        dc.b $1f, $ff, $f8  ; ...##################...
                        dc.b $1f, $ff, $f8  ; ...##################...
                        dc.b $1f, $ff, $f8  ; ...##################...
                        dc.b $1f, $ff, $f8  ; ...##################...
                        dc.b $1f, $ff, $f8  ; ...##################...
                        dc.b $1f, $ff, $f8  ; ...##################...
                        dc.b $1f, $ff, $f8  ; ...##################...
                        dc.b $0f, $ff, $f0  ; ....################....
                        dc.b $07, $ff, $e0  ; .....##############.....
                        dc.b $03, $ff, $c0  ; ......############......
                        dc.b $00, $ff, $00  ; ........########........
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
                        
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_4c          dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $ff, $00  ; ........########........
                        dc.b $03, $ff, $c0  ; ......############......
                        dc.b $07, $ff, $e0  ; .....##############.....
                        dc.b $0f, $ff, $f0  ; ....################....
                        dc.b $1f, $ff, $f8  ; ...##################...
                        dc.b $3f, $ff, $fc  ; ..####################..
                        dc.b $3f, $ff, $fc  ; ..####################..
                        dc.b $3f, $ff, $fc  ; ..####################..
                        dc.b $3f, $ff, $fc  ; ..####################..
                        dc.b $3f, $ff, $fc  ; ..####################..
                        dc.b $3f, $ff, $fc  ; ..####################..
                        dc.b $3f, $ff, $fc  ; ..####################..
                        dc.b $1f, $ff, $f8  ; ...##################...
                        dc.b $0f, $ff, $f0  ; ....################....
                        dc.b $07, $ff, $e0  ; .....##############.....
                        dc.b $03, $ff, $c0  ; ......############......
                        dc.b $00, $ff, $00  ; ........########........
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $00, $00  ; ........................
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Hill_4d          dc.b $00 ; <flag: full sprite data>
                        
                        dc.b $00, $00, $00  ; ........................
                        dc.b $00, $ff, $00  ; ........########........
                        dc.b $03, $ff, $c0  ; ......############......
                        dc.b $07, $ff, $e0  ; .....##############.....
                        dc.b $0f, $ff, $f0  ; ....################....
                        dc.b $1f, $ff, $f8  ; ...##################...
                        dc.b $3f, $ff, $fc  ; ..####################..
                        dc.b $7f, $ff, $fe  ; .######################.
                        dc.b $7f, $ff, $fe  ; .######################.
                        dc.b $7f, $ff, $fe  ; .######################.
                        dc.b $7f, $ff, $fe  ; .######################.
                        dc.b $7f, $ff, $fe  ; .######################.
                        dc.b $7f, $ff, $fe  ; .######################.
                        dc.b $7f, $ff, $fe  ; .######################.
                        dc.b $3f, $ff, $fc  ; ..####################..
                        dc.b $1f, $ff, $f8  ; ...##################...
                        dc.b $0f, $ff, $f0  ; ....################....
                        dc.b $07, $ff, $e0  ; .....##############.....
                        dc.b $03, $ff, $c0  ; ......############......
                        dc.b $00, $ff, $00  ; ........########........
                        dc.b $00, $00, $00  ; ........................
                        
;                        dc.b $ff ; ########
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Map_00           dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ;          ; .....###................
                        dc.b $00 ; ........ ; .....###................
                        dc.b $13 ; 
                        dc.b $00 ; ........
                        dc.b $1b ; 
                        dc.b $07 ; .....###
                        dc.b $1c ; 
                        dc.b $00 ; ........
                        dc.b $1d ; 
                        dc.b $00 ; ........
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $1f ; 
                        dc.b $00 ; ........
                        dc.b $20 ; 
                        dc.b $00 ; ........
                        dc.b $2e ; 
                        dc.b $00 ; ........
                        dc.b $31 ; 
                        dc.b $00 ; ........
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Map_01           dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ;          ; ...........###..........
                        dc.b $1c ; ...###.. ; ...........###..........
                        dc.b $13 ;          ; ........................
                        dc.b $1c ; ...###.. ; ........................
                        dc.b $14 ;          ; .....###................
                        dc.b $00 ; ........ ; .....###................
                        dc.b $15 ; 
                        dc.b $00 ; ........
                        dc.b $16 ; 
                        dc.b $00 ; ........
                        dc.b $1b ; 
                        dc.b $07 ; .....###
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $26 ; 
                        dc.b $00 ; ........
                        dc.b $28 ; 
                        dc.b $00 ; ........
                        dc.b $29 ; 
                        dc.b $00 ; ........
                        dc.b $2a ; 
                        dc.b $00 ; ........
                        dc.b $2d ; 
                        dc.b $00 ; ........
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Map_02           dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ;          ; ...........###..........
                        dc.b $1c ; ...###.. ; ...........###..........
                        dc.b $13 ;          ; ........................
                        dc.b $1c ; ...###.. ; ........................
                        dc.b $1b ;          ; .....###................
                        dc.b $07 ; .....### ; .....###................
                        dc.b $1d ;          ; ........................
                        dc.b $00 ; ........ ; ........................
                        dc.b $1e ;          ; ...........###..........
                        dc.b $07 ; .....### ; ...........###..........
                        dc.b $20 ; 
                        dc.b $00 ; ........
                        dc.b $28 ; 
                        dc.b $1c ; ...###..
                        dc.b $2b ; 
                        dc.b $1c ; ...###..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Map_03           dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0c ;          ; ...........###..........
                        dc.b $00 ; ........ ; ...........###..........
                        dc.b $0f ;          ; ........................
                        dc.b $00 ; ........ ; ........................
                        dc.b $13 ;          ; .....###.........###....
                        dc.b $1c ; ...###.. ; .....###.........###....
                        dc.b $10 ;          ; ........................
                        dc.b $1c ; ...###.. ; ........................
                        dc.b $16 ;          ; ...........###..........
                        dc.b $00 ; ........ ; ...........###..........
                        dc.b $1b ; 
                        dc.b $07 ; .....###
                        dc.b $1d ; 
                        dc.b $70 ; .###....
                        dc.b $1e ; 
                        dc.b $07 ; .....###
                        dc.b $20 ; 
                        dc.b $70 ; .###....
                        dc.b $27 ; 
                        dc.b $00 ; ........
                        dc.b $28 ; 
                        dc.b $1c ; ...###..
                        dc.b $2b ; 
                        dc.b $1c ; ...###..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Map_04           dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0a ;          ; ........................
                        dc.b $1c ; ...###.. ; ...........###..........
                        dc.b $0d ;          ; ...........###..........
                        dc.b $1c ; ...###.. ; ........................
                        dc.b $1b ;          ; ........................
                        dc.b $03 ; ......## ; ........................
                        dc.b $1c ;          ; ........................
                        dc.b $80 ; #....... ; ......###.......###.....
                        dc.b $1d ;          ; ......###.......###.....
                        dc.b $e0 ; ###..... ; ........................
                        dc.b $1e ;          ; ........................
                        dc.b $03 ; ......## ; ...........###..........
                        dc.b $1f ;          ; ...........###..........
                        dc.b $80 ; #.......
                        dc.b $20 ; 
                        dc.b $e0 ; ###.....
                        dc.b $28 ; 
                        dc.b $1c ; ...###..
                        dc.b $2b ; 
                        dc.b $1c ; ...###..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Map_05           dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $0e ;          ; .................###....
                        dc.b $70 ; .###.... ; .................###....
                        dc.b $11 ;          ; .......###..............
                        dc.b $70 ; .###.... ; .......###..............
                        dc.b $12 ;          ; ........................
                        dc.b $01 ; .......# ; ........................
                        dc.b $13 ;          ; ........................
                        dc.b $c0 ; ##...... ; ........................
                        dc.b $15 ;          ; .......###.....###......
                        dc.b $01 ; .......# ; .......###.....###......
                        dc.b $16 ; 
                        dc.b $c0 ; ##......
                        dc.b $24 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $c1 ; ##.....#
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $c1 ; ##.....#
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Map_06           dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $10 ;          ; ...........###..........
                        dc.b $1c ; ...###.. ; ...........###..........
                        dc.b $13 ;          ; ........................
                        dc.b $1c ; ...###.. ; ........................
                        dc.b $1b ;          ; ......###..........###..
                        dc.b $03 ; ......## ; ......###..........###..
                        dc.b $1c ;          ; ........................
                        dc.b $80 ; #....... ; ........................
                        dc.b $1d ;          ; ...........###..........
                        dc.b $1c ; ...###.. ; ...........###..........
                        dc.b $1e ; 
                        dc.b $03 ; ......##
                        dc.b $1f ; 
                        dc.b $80 ; #.......
                        dc.b $20 ; 
                        dc.b $1c ; ...###..
                        dc.b $28 ; 
                        dc.b $1c ; ...###..
                        dc.b $2b ; 
                        dc.b $1c ; ...###..
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Map_07           dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $12 ;          ; .......###.....###......
                        dc.b $01 ; .......# ; .......###.....###......
                        dc.b $13 ;          ; ........................
                        dc.b $c1 ; ##.....# ; ........................
                        dc.b $14 ;          ; ........................
                        dc.b $c0 ; ##...... ; ........................
                        dc.b $15 ;          ; .......###..............
                        dc.b $01 ; .......# ; .......###..............
                        dc.b $16 ;          ; .................###....
                        dc.b $c1 ; ##.....# ; .................###....
                        dc.b $17 ; 
                        dc.b $c0 ; ##......
                        dc.b $24 ; 
                        dc.b $01 ; .......#
                        dc.b $25 ; 
                        dc.b $c0 ; ##......
                        dc.b $27 ; 
                        dc.b $01 ; .......#
                        dc.b $28 ; 
                        dc.b $c0 ; ##......
                        dc.b $2c ; 
                        dc.b $70 ; .###....
                        dc.b $2f ; 
                        dc.b $70 ; .###....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
SP_Dat_Map_08           dc.b $40 ; <flag: partial sprite data>
                        
                        dc.b $12 ;          ; .......###.....###......
                        dc.b $01 ; .......# ; .......###.....###......
                        dc.b $13 ;          ; ........................
                        dc.b $c1 ; ##.....# ; ........................
                        dc.b $14 ;          ; ........................
                        dc.b $c0 ; ##...... ; .....###................
                        dc.b $15 ;          ; .....###.......###......
                        dc.b $01 ; .......# ; ...............###......
                        dc.b $16 ;          ; .........###............
                        dc.b $c1 ; ##.....# ; .........###............
                        dc.b $17 ; 
                        dc.b $c0 ; ##......
                        dc.b $21 ; 
                        dc.b $07 ; .....###
                        dc.b $24 ; 
                        dc.b $07 ; .....###
                        dc.b $25 ; 
                        dc.b $01 ; .......#
                        dc.b $26 ; 
                        dc.b $c0 ; ##......
                        dc.b $28 ; 
                        dc.b $01 ; .......#
                        dc.b $29 ; 
                        dc.b $c0 ; ##......
                        dc.b $2b ; 
                        dc.b $70 ; .###....
                        dc.b $2e ; 
                        dc.b $70 ; .###....
                        
                        dc.b $ff ; <end of data>
; -------------------------------------------------------------------------------------------------------------- ;
